/*
** [BEGIN NOTICE]
**
** Copyright (C) 2005 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The scriptrun homepage is here:
**		http://www.midwinter.com/~lch/programming/scriptrun/
**
** [END NOTICE]
*/


#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>


#ifndef _DEBUG
	#pragma comment(linker, "/OPT:NOWIN98")
	#pragma comment(linker, "/MERGE:.rdata=.data")
	#pragma comment(linker, "/MERGE:.text=.data")
	#pragma comment(linker, "/MERGE:.reloc=.data")
#endif // !_DEBUG



#define strlen lstrlenA
#define strcpy lstrcpyA
#define strcat lstrcatA
#define stricmp lstrcmpiA


char *spaceTable;
#define isspace(x) (spaceTable[x])


#define strrchr mystrrchr
static char *mystrrchr(char *s, int c)
	{
	int count = strlen(s);
	s += count;
	while (count--)
		{
		if (*s == c)
			return s;
		s--;
		}
	return NULL;
	}

static HANDLE processHeap = NULL;
#define malloc mymalloc
static void *mymalloc(size_t size)
	{
	return HeapAlloc(processHeap, 0, size);
	}

#define free myfree
static void myfree(void *foo)
	{
	HeapFree(processHeap, 0, foo);
	}

#define memcpy mymemcpy
static char * memcpy(char *destination, const char *source, size_t count)
	{
	char *returnValue = destination;
	while (count--)
		*destination++ = *source++;
	return returnValue;
	}

#define strdup mystrdup
static char *mystrdup(char *s)
	{
	int length = strlen(s) + 1;
	char *returnValue = (char *)malloc(length);
	if (returnValue != NULL)
		memcpy(returnValue, s, length);
	return returnValue;
	}

#define memcmp mymemcmp
static int mymemcmp(const char *p1, const char *p2, size_t count)
	{
	int returnValue = 0;
	while (count--)
		{
		returnValue = *p1 - *p2;
		if (returnValue != 0)
			break;
		p1++;
		p2++;
		}
	return returnValue;
	}

#define memset(pointer, value, size)		(mymemset((char *)(pointer), (value), (size)))
static void *mymemset(char *pointer, int value, size_t count)
	{
	char *returnValue = pointer;
	while (count--)
		*pointer++ = (char)value;
	return (void *)returnValue;
	}

#define tolower(c) mytolower(c)
static int mytolower(char c)
	{
	if ((c >= 'A') && (c <= 'a'))
		return c + 'a' - 'A';
	return c;
	}

#define strnicmp(p1, p2, count)		(mystrnicmp((char *)(p1), (p2), (count)))
static int mystrnicmp(const char *p1, const char *p2, size_t count)
	{
	int returnValue = 0;
	while (count--)
		{
		returnValue = tolower(*p1) - tolower(*p2);
		// it is sufficient to only check one of the two pointers
		// for zero.  if either string ends before the other,
		// returnvalue is guaranteed to be nonzero.  we really only
		// need to detect when both strings are exactly the same
		// and shorter than "count".
		if ((returnValue != 0) || !*p1)
			break;
		p1++;
		p2++;
		}
	return returnValue;
	}
static char *multiStrcpyValist(char **output, va_list list)
	{
	char *trace = *output;
	for (;;)
		{
		char *s = va_arg(list, char *);
		if (s == NULL)
			break;
		size_t length = strlen(s);
		memcpy(trace, s, length);
		trace += length;
		}

	*trace = 0;
	*output = trace;

	return *output;
	}

static char *multiStrcpy(char **output, ...)
	{
	va_list list;
	va_start(list, output);
	char *returnValue = multiStrcpyValist(output, list);
	va_end(list);

	return returnValue;
	}



void print(char *s, int length = -1)
	{
	DWORD ignored;
	if (length == -1)
		length = strlen(s);
	WriteFile(GetStdHandle(STD_OUTPUT_HANDLE), s, length, &ignored, NULL);
	}
static char messageBuffer[64 * 1024];
void multiPrint(char *s, ...)
	{
	int length = strlen(s);
	memcpy(messageBuffer, s, length + 1);
	char *trace = messageBuffer + length;
	va_list list;
	va_start(list, s);
	multiStrcpyValist(&trace, list);
	va_end(list);
	print(messageBuffer, trace - messageBuffer);
	}

int argvWorker(char *s, char **argv)
	{
	int count = 0;
	for (;;)
		{
		// skip leading whitespace
		while (isspace(*s))
			s++;

		if (!*s)
			break;

		// we're sure we found an argument now.
		count++;
		if (argv != NULL)
			*argv++ = s;

		// copy the argument over itself, stripping out
		// quote marks inline
		//
		// note that this handles the flexible if broken
		// DOS-style quoting, where quotes may appear anywhere.
		// that is,
		//		ab"  c  "de""f
		// and
		//		"ab  c  def"
		// are equivalent strings.
		//
		// furthermore, backslashes that aren't in front of
		// quote marks must be flushed through!  sigh.
		char *output = s;
		int backslash = 0;
		int quoteCharacter = 0;
		for (;;)
			{
			if (!*s)
				break;

			if (quoteCharacter)
				{
				if (*s == quoteCharacter)
					{
					if (!backslash)
						{
						// found the matching quote marker, and it's not backslashd!
						// we stop quoting now.
						quoteCharacter = 0;
						s++;
						continue;
						}
					backslash = 0;
					}
				else if (!backslash && (*s == '\\'))
					{
					backslash = 1;
					s++;
					continue;
					}
				else if (backslash)
					{
					if (argv)
						*output++ = '\\';
					backslash = 0;
					}
				}
			else
				{
				if ((*s == '"') || (*s == '\''))
					{
					quoteCharacter = *s;
					s++;
					continue;
					}
				else if (isspace(*s))
					{
					// an unquoteCharacter whitespace character!
					// that's the end of the current string
					break;
					}
				}
			if (argv)
				*output++ = *s;
			s++;
			}

		int next = (*s != 0);
		if (argv != NULL)
			*output = 0;
		if (next)
			s++;
		}

	if (argv != NULL)
		*argv = NULL;

	return count;
	}

int isFile(char *filename)
	{
	DWORD attributes = GetFileAttributes(filename);
	return (attributes != 0xFFffFFff) && ((attributes & FILE_ATTRIBUTE_DIRECTORY) == 0);
	}





DWORD run(char *commandLine)
	{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	SECURITY_ATTRIBUTES sa;
	DWORD exitCode;
	
	memset(&si, 0, sizeof(STARTUPINFO));
	memset(&pi, 0, sizeof(PROCESS_INFORMATION));
	memset(&sa, 0, sizeof(SECURITY_ATTRIBUTES));
	
	
	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	sa.bInheritHandle = TRUE;
	
	
	si.cb = sizeof(STARTUPINFO);
	si.hStdInput = GetStdHandle(STD_INPUT_HANDLE);
	si.hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
	si.hStdError = GetStdHandle(STD_ERROR_HANDLE);
	
	if (CreateProcess(NULL, commandLine, &sa, NULL, TRUE, 0,
		NULL, NULL, &si, &pi))
		{
		WaitForSingleObject(pi.hProcess, INFINITE);
		GetExitCodeProcess(pi.hProcess, &exitCode);
		CloseHandle(pi.hThread);
		CloseHandle(pi.hProcess);
		}
	
	return exitCode;
	}



struct scriptHandlers
	{
	char *extension;
	char *matchingProgram;
	int supportUnixMagicValue;
	};


scriptHandlers handlers[] =
	{
	{ ".py", "python.exe", 1 },
	{ ".sh", "sh.exe", 1 },
	{ ".f", "ficl.exe", 0 },
	{ ".pl", "perl.exe", 1 }, // blech!  ptui!

	{ NULL, NULL }
	};


int WinMainCRTStartup(void)
	{
	// used by malloc() etc
	processHeap = GetProcessHeap();

	// set up the table for my quick isspace() fn
	spaceTable = (char *)malloc(256);
	memset(spaceTable, 0, 256);
	spaceTable[' '] = 1;
	spaceTable['\t'] = 1;
	spaceTable['\r'] = 1;
	spaceTable['\n'] = 1;

	int i;
	char *trace;
	char *commandLine = strdup(GetCommandLine());
	char *script = NULL;
	char *scriptBuffer = NULL;
	int argc;
	char **argv = NULL;
	char *first4k = NULL;
	char *extension = NULL;
	char *handler = NULL;
	

	// dice up command-line into argc/argv
	argc = argvWorker(commandLine, NULL);
	argv = (char **)malloc((argc + 1) * sizeof(char *));
	argvWorker(commandLine, argv);

	int length = strlen(argv[0]);

	// print usage if necessary
	static char *scriptrunexe = "scriptrun.exe";
	if (!stricmp(argv[0] + length - strlen(scriptrunexe), scriptrunexe))
		{
		print("ScriptRun 1.0\nCopyright 2005 Larry Hastings\nhttp://www.midwinter.com/~lch/programming/scriptrun\nSee homepage for usage and license.\n\n");
		goto EXIT;
		}
		
	// analyze argv[0] to try and determine the script.
	script = scriptBuffer = (char *)malloc((length * 2) + 20);
	if (script == NULL)
		goto EXIT;
	memcpy(script, argv[0], length + 1);
	trace = strrchr(script, '.');
	if (trace == NULL)
		goto FAILURE;
	scriptHandlers *handlersTrace;
	int tryUnixMagicValue;
	tryUnixMagicValue = 0;

	*trace = 0;

	// if they renamed scriptrun such that stripping .exe
	// is still a valid filename (like "<<scriptname>>.py.exe")
	// then just use that.
	if (isFile(script))
		{
		char *trace2 = strrchr(script, '.');
		if (trace2 == NULL)
			goto NOT_A_FILE;

		for (handlersTrace = handlers; handlersTrace->extension != NULL; handlersTrace++)
			{
			if (!stricmp(trace2, handlersTrace->extension))
				goto FOUND;
			}
		}
NOT_A_FILE:
	// okay, so it wasn't "<<scriptname>>.py.exe".
	// try adding each of the extensions to the end.
	for (handlersTrace = handlers; handlersTrace->extension != NULL; handlersTrace++)
		{
		strcpy(trace, handlersTrace->extension);
		if (isFile(script))
			goto FOUND;
		}

	handlersTrace = NULL;

	// okay, we really gotta work for this one.
	// scan the directory for files that start with
	// our basename.  if we see exactly two, one being
	// the currently-running program, then the other is
	// probably the script they wanted us to handle.
	// (note that this only works for #!-magic-value
	// files.)
	strcpy(trace, ".*");
	WIN32_FIND_DATA wfd;
	memset(&wfd, 0, sizeof(wfd));
	HANDLE hFind;
	int count;
	hFind = FindFirstFile(script, &wfd);
	count = 0;
	int argv0length;
	argv0length = strlen(argv[0]);
	for (;;)
		{
		int length = strlen(wfd.cFileName);
		int offset = 0;
		if (argv0length > length)
			offset += argv0length - length;
		if (stricmp(argv[0] + offset, wfd.cFileName))
			count++;
		if (count == 2)
			break;
		if (!FindNextFile(hFind, &wfd))
			break;
		}
	FindClose(hFind);

	if (count != 1)
		goto FAILURE;
	script = wfd.cFileName;
	tryUnixMagicValue = 1;

FOUND:
	if (handlersTrace != NULL)
		{
		tryUnixMagicValue |= handlersTrace->supportUnixMagicValue;
		extension = handlersTrace->extension;
		}
	else
		{
		extension = strrchr(script, '.');
		}


	// okay, we found a script we want to run.
	//
	// if it makes sense to, open the file and
	// pull out the first line and see if it
	// starts with #!.  if it does, that takes
	// precedence.
	if (tryUnixMagicValue)
		{
		first4k = (char *)malloc(4097);
		if (first4k == NULL)
			goto FAILURE;
		HANDLE hFile = CreateFile(script, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
		if (hFile == INVALID_HANDLE_VALUE)
			goto FAILURE;
		DWORD got = 0;
		ReadFile(hFile, first4k, 4096, &got, NULL);
		CloseHandle(hFile);
		first4k[got] = 0;
		if ((first4k[0] == '#') && (first4k[1] == '!'))
			{
			handler = first4k + 2;
			while (isspace(*handler))
				handler++;
			char *trace = handler;
			while (*trace && (*trace != '\r') && (*trace != '\n'))
				trace++;
			*trace = 0;
			goto EXECUTE;
			}
		}

	// if we got here, for whatever reason, we didn't find #! in the file.
	// see if they've set an explicit handler in the environment.
	// where you set SCRIPTRUN_<<extension NOT including dot>>
	// to point to an executor
	if (extension != NULL)
		{
		char envrionmentVariableName[256];
		strcpy(envrionmentVariableName, "SCRIPTRUN_");
		strcat(envrionmentVariableName, extension + 1);
		char explicitHandler[_MAX_PATH];
		*explicitHandler = 0;
		GetEnvironmentVariable(envrionmentVariableName, explicitHandler, sizeof(explicitHandler));
		if (*explicitHandler != 0)
			{
			handler = explicitHandler;
			goto EXECUTE;
			}
		}

	// okay, they didn't override the launcher.
	// use the conventional executor
	if (handlersTrace == NULL)
		goto FAILURE;
	handler = handlersTrace->matchingProgram;


EXECUTE:
	// finally!  launch the executor on the script.
	int commandLineLength;
	commandLineLength = 0;
	char *scriptorArguments;
	int firstArgument;
	if ((argc == 1) || (strnicmp(argv[1], "-sr:", 4)))
		{
		firstArgument = 1;
		scriptorArguments = "";
		}
	else
		{
		firstArgument = 2;
		scriptorArguments = argv[1] + 4;
		}
	commandLineLength += 1 /* " */ + strlen(handler) + 3 /* " _ " */ + strlen(script) + 2 /* " and trailing 0 */;
	for (i = 1; i < argc; i++)
		commandLineLength += 2 /* _ " */ + strlen(argv[i]) + 1 /* " */;
	commandLine = (char *)malloc(commandLineLength);
	trace = commandLine;
	multiStrcpy(&trace, "\"", handler, "\" ", scriptorArguments, " \"", script, "\"", NULL);
	for (i = firstArgument; i < argc; i++)
		multiStrcpy(&trace, " \"", argv[i], "\"", NULL);

	run(commandLine);
	goto EXIT;

FAILURE:
	multiPrint("scriptrun: could't find script for \"", argv[0], "\", exiting.\n", NULL);

EXIT:
	if (commandLine != NULL)
		free(commandLine);
	if (argv != NULL)
		free(argv);
	if (first4k != NULL)
		free(first4k);
	if (scriptBuffer != NULL)
		free(scriptBuffer);

	return 0;
	}



#ifdef _DEBUG
int main(int argc, char *argv[])
	{
	return WinMainCRTStartup();
	}
#endif // _DEBUG
