/*
** [BEGIN NOTICE]
**
** Copyright (C) 2003 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The pngscreenshot homepage is here:
**		http://www.midwinter.com/~lch/programming/pngscreenshot/
**
** [END NOTICE]
*/

#include <assert.h>
#include <windows.h>
#include <d3d8.h>
#include <png.h>


static void pngWin32WriteData(png_structp png_ptr, png_bytep data, png_size_t length)
	{
	png_uint_32 check;
	
	if (!WriteFile((HANDLE)(png_ptr->io_ptr), data, length, &check, NULL))
		check = 0;
	if (check != length)
		png_error(png_ptr, "Write Error");
	}

static void pngWin32Flush(png_structp png_ptr)
	{
	FlushFileBuffers((HANDLE)(png_ptr->io_ptr));
	}

static void PNGAPI pngError(png_structp s, png_const_charp message)
	{
	OutputDebugString("PNG ERROR:");
	OutputDebugString(message);
	OutputDebugString("\n");
	}

static void PNGAPI pngWarning(png_structp s, png_const_charp message)
	{
	OutputDebugString("PNG Warning:");
	OutputDebugString(message);
	OutputDebugString("\n");
	}

/* if the expression "expr" is false, bug out. */
#define ASSERT(expr)	\
	{					\
	if (!(expr))		\
		{				\
		goto EXIT;		\
		}				\
	}					\
		

static void writePng(char *filename, IDirect3DSurface8 *surface)
	{
	HANDLE hFile;
	png_structp png_ptr = NULL;
	png_infop info_ptr = NULL;
	png_bytep *row_pointers = NULL;

	D3DSURFACE_DESC surfaceDescription;
	surface->GetDesc(&surfaceDescription);

	hFile = CreateFile(filename, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, 0, NULL);
	ASSERT(hFile != INVALID_HANDLE_VALUE);

	png_ptr = png_create_write_struct(PNG_LIBPNG_VER_STRING, NULL, pngError, pngWarning);
	ASSERT(png_ptr != NULL);

	info_ptr = png_create_info_struct(png_ptr);
	ASSERT(info_ptr != NULL);

	png_set_write_fn(png_ptr, (void *)hFile, pngWin32WriteData, pngWin32Flush);

	assert(surfaceDescription.Format == D3DFMT_A8R8G8B8);
	png_set_IHDR(png_ptr, info_ptr, surfaceDescription.Width,
		surfaceDescription.Height, 8, PNG_COLOR_TYPE_RGB,
		PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_BASE, PNG_FILTER_TYPE_BASE);

	png_write_info(png_ptr, info_ptr);

	// Intel is little-endian, so we have to rearrange the colors.
	png_set_bgr(png_ptr);
	// We also might as well strip out the alpha and make the PNG a little smaller.
	png_set_filler(png_ptr, 0, PNG_FILLER_AFTER);

	D3DLOCKED_RECT lockedRectangle;
	surface->LockRect(&lockedRectangle, 0, D3DLOCK_READONLY);

	row_pointers = (png_bytep *)malloc(sizeof(png_bytep) * surfaceDescription.Height);
	DWORD k;
	for (k = 0; k < surfaceDescription.Height; k++)
		row_pointers[k] = ((png_bytep)lockedRectangle.pBits) + (lockedRectangle.Pitch * k);

	png_write_image(png_ptr, row_pointers);

	png_write_end(png_ptr, info_ptr);

	png_destroy_write_struct(&png_ptr, &info_ptr);

EXIT:
	if (hFile != INVALID_HANDLE_VALUE)
		CloseHandle(hFile);

	if ((png_ptr != NULL) || (info_ptr != NULL))
		png_destroy_write_struct(&png_ptr, &info_ptr);

	if (row_pointers != NULL)
		free(row_pointers);
	}


void screenshot(LPDIRECT3DDEVICE8 display, int width, int height, char *filename)
	{
	char filenameBuffer[_MAX_PATH];
	if (filename == NULL)
		{
		DWORD i;
		filename = filenameBuffer;
		for (i = 1; i < 0xFFFFffff; i++)
			{
			sprintf(filename, "screenshot.%u.png", i);
			if (GetFileAttributes(filename) == 0xFFffFFff)
				break;
			}
		}

	IDirect3DSurface8 *surface = NULL;
	display->CreateImageSurface(width, height, D3DFMT_A8R8G8B8, &surface);
	display->GetFrontBuffer(surface);
	writePng(filename, surface);
	surface->Release();
	}

