#!/usr/bin/python

#
#	TODO
#	* write a generalized command recognizer similar to what monotone does.
#		* e.g. you can type "monotone com" and it will be recognized as "commit"
#		  because there is only one monotone command that starts with "com".
#		  that will require building a list of all the recognized commands, sigh.

#
# m7
version = "0.8"
#
# [BEGIN NOTICE]
#
# m7
# Copyright 2005-2006 Larry Hastings
#
# This software is provided 'as-is', without any express or implied warranty.
# In no event will the authors be held liable for any damages arising from
# the use of this software.
#
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute
# it freely, subject to the following restrictions:
#
# 1. The origin of this software must not be misrepresented; you must not
#    claim that you wrote the original software. If you use this software
#    in a product, an acknowledgment in the product documentation would be
#    appreciated but is not required.
# 2. Altered source versions must be plainly marked as such, and must not be
#    misrepresented as being the original software.
# 3. This notice may not be removed or altered from any source distribution.
#
# The m7 homepage is here:
#		http://www.midwinter.com/~lch/programming/m7/
#
# If you're using m7, I'd love to hear from you!  Email me at
#	larry@hastings.org
#
# [END NOTICE]
#


import ConfigParser
import cStringIO
import copy
import getpass
import os
import platform
import re
import string
import sys





def newspawn(arguments):
	if sys.platform == "win32":
		si = subprocess.STARTUPINFO()
		si.dwFlags |= subprocess.STARTF_USESHOWWINDOW
		si.wShowWindow = 0 # SW_HIDE
	else:
		si = None
	child = subprocess.Popen(arguments, startupinfo=si, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, bufsize=0)
	return child.stdout

def oldspawn(arguments):
	(stdout, stdin) = popen2.popen4(quoted, 0, mode="t")
	return stdout

# sys.version_info was new as of 2.0,
# so this code won't work for 1.x series.
# Not sure what the minimum version we need
# is, but it's got to be a 2.x, because m7
# uses string methods a *lot*.
if (sys.version_info[0] == 2) and (sys.version_info[1] < 4):
	import popen2
	spawn = oldspawn
else:
	import subprocess
	spawn = newspawn


dbArgument = None

# arguments is an array
def monotone(arguments, output=False, system=False):

	global dbArgument
	if dbArgument != None:
		arguments.insert(0, dbArgument)

	# print str(arguments)

	if system:
		os.system("mtn \"" + "\" \"".join(arguments) + "\"")
		return None

	arguments.insert(0, "mtn")
	stdout = spawn(arguments)

	if output and stdout:
		for line in stdout.readlines():
			print line,
		# currently, if you print the output of the
		# command, you can't parse it too.
		# (you can't seek on stdout.)
		# I can fix this by reading in stdout and
		# turning it into a StringIO, but I don't
		# need to yet.
		return None

	return stdout


def usage():
    monotone([], output=True, system=True)
    print "Additional commands for m7:"
    print "  " + "unpopulate" + "\t" + "locally removes all old-style m7 certs and vars"
    print "  " + "tannotate file [id]" + "\t" + "runs annotate, but changes revision ids"
    print "  " + "\t\t\t" + "to their local revision numbers"
    print "  " + "\t\t\t" + "optional id is of earliest revision to display"
    print "  " + "uannotate" + "\t" + "untagged annotate, displays \"mtn annotate\" unmodified"
    print "  " + "The default behavior for annotate is uannotate.  Change it by running this:"
    print "  " + "\tm7 set org.hastings.m7 preferTannotate 1"
    sys.exit(0)



if len(sys.argv) == 1:
	usage()






settings = {}

def setSetting(name, value):
	monotone(["set", "org.hastings.m7", name, value])

specialPrefix = None

mapDefaultSettings = {
	"revisionPrefix" : ":",
	"preferTannotate" : "0",
	"autoExecuteDropAndRename" : "1",
	}

def defaultSettings():
	global mapDefaultSettings
	print "m7      : setting default vars"
	for name, value in mapDefaultSettings.iteritems():
		setSetting(name, value)

def readSettings():
	global settings
	global specialPrefix
	global mapDefaultSettings
	stdout = monotone(["list", "vars", "org.hastings.m7"])
	stdout = "\n".join(stdout.readlines())
	if stdout.startswith("mtn: misuse: "):
		return False
	var = re.compile("^org.hastings.m7: ([^ \t]+) (.*)")
	for line in stdout.splitlines():
		match = var.match(line)
		if match != None:
			settings[match.group(1)] = match.group(2)
	somethingWasUnset = False
	for name, value in mapDefaultSettings.iteritems():
		if not (name in settings):
			somethingWasUnset = True
			setSetting(name, value)
	if somethingWasUnset:
		print "m7      : setting default vars"
		readSettings()
	specialPrefix = settings["revisionPrefix"]
	return True



def incrementRevision():
	global settings
	revision = settings["revisionNumber"] = str( int(settings["revisionNumber"]) + 1 )
	return revision

def writeSettings():
	# only write out the ones that m7 actually changes
	for s in [ "revisionNumber" ]:
		setSetting(s, settings[s])






m7Revisions = {}
m7ReverseRevisions = {}
tags = {}
tagsCached = False


def cacheTags():
	global tagsCached
	if tagsCached:
		return
	tagsCached = True

	global m7Revisions
	global m7ReverseRevisions
	global tags

	output = monotone(["db", "execute", 'select _ROWID_,id from revisions'])
	for line in output.readlines():
		if "|" in line:
			id, value = line.split("|")
			m7Revisions[value.strip()] = id.strip()
			m7ReverseRevisions[id.strip()] = value.strip()

	output = monotone(["list", "tags"])
	for line in output.readlines():
		fields = line.split()
		tags[fields[1]] = fields[0]



def handleSpecialTags(argument):
	if not argument.startswith(specialPrefix):
		return argument
	cacheTags()
	revision = argument[len(specialPrefix):]
	try:
		returnValue = m7ReverseRevisions[revision]
	except KeyError:
		sys.exit("m7      : couldn't expand " + argument + ", no matching revision\n")
	sys.stderr.write("m7      : expanding " + argument + " to " + returnValue + "\n")
	return returnValue


def getRevisionStyleTag(revision, allTags=None):
	global m7Revisions
	if not revision in m7Revisions:
		return None
	return settings["revisionPrefix"] + m7Revisions[revision]


def getTag(revision, allTags=None):
	cacheTags()

	global tags

	revisionTag = getRevisionStyleTag(revision)
	tag = None
	if revision in tags:
		tag = tags[revision]

	if revisionTag:
		if allTags and tag:
			return tag + " " + revisionTag
		return revisionTag
	if tag:
		return tag
	return revision




def getDateAndAuthorForTag(tag):
	output = monotone(["list", "certs", tag])
	date = None
	lineIsDate = False
	author = None
	lineIsAuthor = False
	for line in output.readlines():
		line = line.strip()
		if line == "Name  : date":
			lineIsDate = True
		elif lineIsDate:
			lineIsDate = False
			date = line.split(":", 1)[1].strip()
		elif line == "Name  : author":
			lineIsAuthor = True
		elif lineIsAuthor:
			lineIsAuthor = False
			author = line.split(":", 1)[1].strip()
	return (date, author)



arguments = sys.argv[1:]
prearguments = []

for argument in arguments:
	# if we can find a --db argument in
	# the command-line, make a copy of it
	if argument.startswith("--db="):
		dbArgument = argument
		break
	elif argument == "--version":
		print "m7 version " + version




# as good a place as any to detect this:
# if no database is available, give up
# and just execute the command directly
if not readSettings():
	monotone(arguments, system=True)
	sys.exit(0)



while arguments[0].startswith("--") and ("=" in arguments[0]):
	prearguments.append(arguments[0])
	arguments = arguments[1:]
	if len(arguments) == 0:
		arguments = [""]


def handleArgument(i):
    arguments[i] = handleSpecialTags(arguments[i])

def findAndRemoveArgument(s):
    global arguments
    try:
        index = arguments.index(s)
        arguments = arguments[:index] + arguments[index + 1:]
        return True
    except ValueError:
        pass
    return False

for i in range(len(arguments)):
	a = arguments[i]
	if "=" in a:
		prefix, suffix = a.split("=")
		if prefix in ("--revision", "-r"):
			suffix = handleSpecialTags(suffix)
			arguments[i] = prefix + "=" + suffix



# handle the "default" behavior for annotate
if arguments[0] in [ "annotate", "a" ]:
	if int(settings["preferTannotate"]):
		arguments[0] = "tannotate"
	else:
		arguments[0] = "uannotate"



if 0:
	pass

elif arguments[0] == "cat":
	if (len(arguments) >= 3) and (arguments[1] in ("revision", "-r", "--revision") ):
		handleArgument(2)

elif arguments[0] in [ "commit", "c", "ci", "com", "comm", "commi" ]:
	arguments[0] = "commit"
	# don't get cocky, it's gonna get rocky,
	# we're gonna split it up into steps, ya jockey, now--
	#
	# without an explicit --message or --message-file, "monotone commit"
	# wants to present the user with an editor and let them type their
	# revision comment.  that doesn't work when monotone is run with pipes.
	# however, running "monotone commit" is the surest way to get the
	# new revision id out.
	#
	# the best way to fix this, probably, would be to run the editor
	# *ourselves*.  but that's complicated, and it's late.  so I do this:
	#
	# first, run monotone normally, no pipes, so the user can type comments.
	monotone(prearguments + arguments, system=True)
	# second, immediately afterwards, get the status, and pull out "old revision".
	stdout = monotone(["status"])
	reFindId = re.compile("^Changes against parent ([0-9a-fA-F]{40}):$")
	for line in stdout.readlines():
		match = reFindId.match(line.strip())
		if match != None:
			revision = match.group(1)
			# special handling: if this is the first commit we've done in a new directory,
			# our initial read of the vars from the database failed.  so, if that failed,
			# re-read'em now.  this is a bit hillbilly; we *should* have used the --db argument
			# when we did the list-vars stuff.  but that's for later, when m7 is more than
			# a reasonably well-executed proof-of-concept.  --lch
			if len(settings) == 0:
				readSettings()
			# recache tags
			tagsCached = False
			cacheTags()
			print "m7      : local revision is " + settings["revisionPrefix"] + m7Revisions[revision]
			break
	sys.exit(0)

elif arguments[0] in ["approve", "cert", "certs", "comment", "fdata", "disapprove", "mdata", "rdata", "update", "tag", "testresult", "trusted"] :
    if (len(arguments) >= 2):
        handleArgument(1)

elif arguments[0] == "db":
    if (len(arguments) >= 3) and (arguments[1] == "kill_rev_locally"):
        handleArgument(2)

elif arguments[0] == "d":
	arguments[0] = "diff"

elif arguments[0] == "s":
	arguments[0] = "status"

elif arguments[0] == "automate":
    if (len(arguments) >= 3) and (arguments[1] in [ "ancestors", "ancestry_difference", "certs", "children", "descendents", "erase_ancestors", "get_revision", "parents", "toposort" ]):
        for i in range(2, len(arguments)):
            handleArgument(i)

elif arguments[0] in [ "explicit_merge", "fdelta", "mdelta" ]:
    if (len(arguments) >= 3):
        handleArgument(1)
        handleArgument(2)

elif arguments[0] == "list":
    if (len(arguments) >= 3):
        if arguments[1] == "certs":
            handleArgument(2)

elif arguments[0] in ["log", "l"]:
    arguments[0] = "log"
    cacheTags()
    
    # it seems like mtn's argument parsing is really flexible
    # aka a pain to re-implement here
    isARevision = False
    revisedArguments = []
    for a in arguments:
        if isARevision:
            revisedArguments.append(handleSpecialTags(a))
        elif a in ("-r", "--revision"):
            isARevision = True
            revisedArguments.append(a)
        elif a.startswith("-r"):
            revisedArguments.append("-r")
            revisedArguments.append(handleSpecialTags(a[2:]))
        elif a.startswith("-r") or a.startswith("--revision"):
            revisedArguments.append("--revision")
            revisedArguments.append(handleSpecialTags(a[10:]))
        else:
            revisedArguments.append(a)
    arguments = revisedArguments

    tagFinder = re.compile("^(Revision|Ancestor): ([0-9A-Fa-f]{40})")

    output = monotone(prearguments + arguments)
    for line in output.readlines():
        line = line.rstrip()
    
        match = tagFinder.match(line)
        if (match != None) and  (getTag(match.group(2)) != None):
            print match.group(1) + ": " + getTag(match.group(2)) + " " + match.group(2)
        else:
            print line
    
    sys.exit(0)

# untagged annotate:
elif arguments[0] in [ "uannotate", "ua" ]:
	arguments[0] = "annotate"

# tagged annotate
elif arguments[0] in [ "tannotate", "ta" ]:
    arguments[0] = "annotate"

    useBrief = findAndRemoveArgument("--brief") or findAndRemoveArgument("-b")
    noTags = findAndRemoveArgument("--notags")

    if len(arguments) < 2:
        usage()

    cacheTags()

    revisionMap = {}
    revisionInfo = {}

    if useBrief and (len(arguments) == 2):
        revisions = m7Revisions.keys()
    else:
        # get all revisions of file, newest first
        revisions = []
        output = monotone(["log", arguments[1]])
        reRevision = re.compile("^Revision: ([0-9A-Fa-f]{40})")
        reAuthor = re.compile("^Author: (.+)$")
        reDate = re.compile("^Date: (.+)$")
        author = ""
        date = ""
        revision = None
        for line in output.readlines():
            match = reRevision.match(line)
            if match != None:
                if revision != None:
                    revisionInfo[revision] = (author, date)
                revision = match.group(1)
                revisions.append(revision)
                continue
    
            match = reAuthor.match(line)
            if match != None:
                author = match.group(1).strip()
                continue
    
            match = reDate.match(line)
            if match != None:
                date = match.group(1).strip()
                continue
        revisionInfo[revision] = (author, date)

    skippedRevisions = []
    if len(arguments) > 2:
        # specified earliest revision, too
        earliestRevision = arguments[2]
        arguments = arguments[:2]

        earliestRevision = handleSpecialTags(earliestRevision)
        if len(earliestRevision) != 40:
            # change earliestRevision from whatever into a hash
            # is there a better way to do this?  I dunno.
            output = monotone(["cat", "revision", earliestRevision])
            for line in output.readlines():
                if line.startswith("mtn: expanded to '"):
                    earliestRevision = line.split("'")[1]
                    break
            # cheap error-checking, should really do regexp here or something
            if len(earliestRevision) != 40:
                sys.exit("m7      : revision \"" + earliestRevision + "\" is unknown (did you mean \"" + settings["revisionPrefix"] + earliestRevision + "\"?)")

        # find all revisions newer than or equal to that hash
        # since we already have them in newest to oldest order,
        # just add until we find the above hash value.
        skip = False
        for revision in revisions:
            if skip:
                skippedRevisions.append(revision)
            elif revision == earliestRevision:
                skip = True
    
    maxLength = 0
    for revision in revisions:
        if revision in skippedRevisions:
            continue
        if noTags:
            revisionSummary = getRevisionStyleTag(revision)
        else:
            revisionSummary = getTag(revision, allTags=True)
        if revisionSummary != revision:
            revisionSummary += " "
        maxLength = max(maxLength, len(revisionSummary))
        revisionMap[revision] = revisionSummary

    # pre-widen all strings
    skipTag = "".rjust(maxLength)
    for revision in revisionMap:
        revisionMap[revision] = revisionMap[revision].rjust(maxLength)

    if ("--quiet" not in arguments) and ("--reallyquiet" not in arguments):
        arguments.insert(1, "--quiet")
    if "--brief" not in arguments:
        arguments.insert(1, "--brief")
    output = monotone(prearguments + arguments)
    # print "maxLength is " + str(maxLength)

    if not useBrief:
        reversedRevisions = []
        reversedRevisions.extend(revisions)
        reversedRevisions.reverse()
        print "# tannotate legend:"
        for revision in reversedRevisions:
            if revision in skippedRevisions:
                continue
            name, date = revisionInfo[revision]
            print "# " + revisionMap[revision] + revision + " " + name + " " + date
        print ""

    tagFinder = re.compile("^([0-9A-Fa-f]{40})(:.*)") # finds the tag on a line of the annotated output
    for line in output.readlines():
        line = line.rstrip()

        match = tagFinder.match(line)
        if (match == None):
            # no tag on this line, just print it out
            print line
            continue

        revision = match.group(1)
        trailing = match.group(2)
        if revision in revisionMap:
            tag = revisionMap[revision]
        else:
            tag = skipTag
        print tag + trailing
    sys.exit(0)

elif arguments[0] in ["rename", "drop", "rm" ]:
	if int(settings["autoExecuteDropAndRename"]):
		if "--noexecute" in arguments:
			index = arguments.index("--noexecute")
			del arguments[index]
		else:
			arguments.append("--execute")

elif arguments[0] == "unpopulate":
    monotone(["db", "execute", "delete from revision_certs where name like 'm7-db-'" ])
    for oldVar in ("databaseNicknameFormat", "revisionNumber"):
        monotone(["unset", "org.hastings.m7", oldVar])
    print "m7      : Removed old m7 certs and vars."
    sys.exit(0)

elif (arguments[0] == "help") and (len(arguments) == 1):
    usage()



# A SEKRIT OPTIONS!!!!!!!1
# I use this when I'm hacking on m7 now and then. --lch
elif arguments[0] == "resetm7":
	defaultSettings()
	sys.exit(0)

monotone(prearguments + arguments, system=True)

