// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

: reflectPlusFour ;

: testreflect
	reflect
	if   ."reflect worked!"
	else ."reflect failed!"
	endif
	cr
	;

create plusFour-methodArguments "FijiInterpreter" ,
create plusFour-constructorArguments 

	"FijiPlusFour"
	plusFour-constructorArguments
	"execute"
	plusFour-methodArguments
	java.lang.Void

testreflect
 ' reflectPlusFour cfa!

10000 constant loops
// 100 constant loops

: runtests
	clock
	// 9 +4 is 13
	// why the "0 drop"?  see below.
	loops 0 do 9  0 drop javaaddfour drop loop
	clock

	loops . ."iterations of direct execution: "
	swap - .. ."ms" cr

	// 9 +4 is 13
	// why the "0" between the 9 and the push-fiji-interpreter?
	// as a direct CFA, FijiPlusFour.execute expects its PFA on the
	// stack, which it simply pops.  the 0 is grist for the mill.
	// to handicap the direct-call loop code above, I added the "0 drop" above.
	clock
	loops 0 do 9 0 push-fiji-interpreter reflectPlusFour drop loop
	clock

	loops . ."iterations of reflection: "
	swap - .. ."ms" cr
	;

runtests

