// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// value.f
//
// A "value" is more like a traditional programming language variable.
// Whenever it is referenced, it pushes its "value" on the stack.


// This line creates a value called "foo", which is initially set to 5:

5 value foo

// debug scaffolding
: fooshouldbe
	."foo should be " dup 2 .r
	.", but it is actually " foo 2 .r
	.", so it "
	foo =
	if
		."worked!"
	else
		."failed!"
	endif
	cr
	;



5 fooshouldbe

// To change its value, use the word "to", as this line demonstrates:
87 to foo

87 fooshouldbe

: testto 49 to foo ;
testto
49 fooshouldbe

