// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// string.f
//
// A thorough test of Fiji's string comparison operators.

// Comparing two strings with the normal math operators returns
// a true/false result:
: test1 2dup ;
: test2 rot . swap . . cr ;
"a" "b" test1 < test2
"a" "b" test1 <= test2
"a" "b" test1 == test2
"a" "b" test1 >= test2
"a" "b" test1 > test2
"a" "b" test1 != test2
cr

"b" "a" test1 < test2
"b" "a" test1 <= test2
"b" "a" test1 == test2
"b" "a" test1 >= test2
"b" "a" test1 > test2
"b" "a" test1 != test2
cr

"a" "a" test1 < test2
"a" "a" test1 <= test2
"a" "a" test1 == test2
"a" "a" test1 >= test2
"a" "a" test1 > test2
"a" "a" test1 != test2
cr

// stricmp acts like the conventional C function stricmp(); it does
// a case-insensitive string comparison, leaving a zero if the strings
// are the same, a number < 0 if the left (bottom) string sorted earlier
// in the alphabet, and > 0 if the right (top) string sorted earlier.
"a" "a" test1 stricmp test2
"A" "a" test1 stricmp test2
"a" "A" test1 stricmp test2
"A" "A" test1 stricmp test2
cr

"b" "a" test1 stricmp test2
"B" "a" test1 stricmp test2
"b" "A" test1 stricmp test2
"B" "A" test1 stricmp test2
cr

"a" "b" test1 stricmp test2
"A" "b" test1 stricmp test2
"a" "B" test1 stricmp test2
"A" "B" test1 stricmp test2
cr

// strtok serves the same function as C's strtok().
// strtok ( string-to-parse tokens-string -- strings*i i )
// "string-to-parse" will be split up at groups of characters
// matching characters from "tokens-string", and all the new
// strings pushed.  The count of resulting strings will be
// left on the top of the stack.
// If no characters matched, strtok will push the original
// "string-to-parse" with a 1 on top.

: teststrtok 2dup swap ."strtok '" .. ."' with '" .. ."' gives us " strtok dup dup . ."string" 1 > if ."s" endif .":" cr ."  " 0 do ."'" .. ."' " loop cr ;
"abc*def" "*" teststrtok
"abc*def*ghi*jkl*mno" "*" teststrtok
"foo)" ")" teststrtok
"bar" ")" teststrtok

// popchar removes the front character from a string and
// pops it on the top of the stack.  when the string
// is empty, it pushes a character 0.
: testpopchar
	."testing popchar.  splitting up this string:" cr
	dup ."    '" .. ."'" cr
	."into individual characters becomes:" cr
	."   "
	begin popchar dup 0 >char != while ."'" .. ."' " repeat cr
	cr
	;

"all the lonely people, where do they all come from"
testpopchar

// just testing the "doublequote" and "sp" words:
."here is a double quote character: ->" doublequote .. ."<-" cr
."here is a space character: ->" sp .. ."<-" cr
