// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// numbers.f
//
// when Fiji sees a word it doesn't recognize, it tries to convert it
// into a number.  By default, integer numbers are turned into Integer
// objects, and floating-point numbers are turned into Double objects.
//
// Fiji doesn't implement the standard Forth way of entering numbers.
// That convention uses a single "base" variable, and automatic
// conversion from/to bases as it is changed:
//		"decimal 16 hex ." would print "10"
//		"hex 10 decimal ." would print "16"
// Instead, Fiji allows you to prepend a number with "0x" to indicate
// it is hex, "0o" to indicate it is octal (yes, just "0" will suffice),
// and "0b" to indicate it is binary.

."trying hex numbers:"
	cr
	."  0x17 (23):"
	cr
	."    " 0x17 dup dup dup ."decimal " . ."hex " .x  ."octal " .o ."binary " .b
	cr
	."  0xbabe (something large):"
	cr
	."    " 0xbabe dup dup dup ."decimal " . ."hex " .x  ."octal " .o ."binary " .b
	cr

// Similarly, you can follow any . or ? command with x, o, or b to print
// the number in hex, octal, or binary.
create foo 89 ,
."trying eight flavors of '?':"
cr
."  "
	."->" foo ? ."<- "
	."->" foo ?? ."<- "
	."->" foo ?x ."<- "
	."->" foo ??x ."<- "
	cr
."  "
	."->" foo ?o ."<- "
	."->" foo ??o ."<- "
	."->" foo ?b ."<- "
	."->" foo ??b ."<- "
	cr

// Finally, Fiji also supports suffixes for numbers, indicating what
// class the number should be.  A trailing B means a Byte, a trailing
// L means a Long, a trailing F means a Float, and so on.  The oddest
// one is a trailing C meaning a Character.  This is a bit unnerving,
// as you will see below.
: .class dup >class swap ."class of " . ."is " . cr ;
125 .class
12 .class
-1 .class
-10 .class
12B .class
34C .class
12S .class
12L .class
15.0 .class
15.0F .class

bye