// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// inline.f
//
// A demonstration of Fiji's "inline" words.  An "inline" word
// is a word that works normally at runtime, but at compile
// time dumps its contents out into the calling word.  This
// yields the usual tradeoff: a minor speed increase with a
// minor size increase.

: swaptwice swap swap ; inline
: testinline ."hello" 3 4 swaptwice . . cr ;
see testinline

: testnestedif1 if 100 else -100 endif ; inline
: testnestedif2 if testnestedif1 else testnestedif1 endif ; inline
see testnestedif2
: nestedifs ."testing!" 1 testnestedif2 . ;
nestedifs
see nestedifs
