// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// hanoi.f
//
// The Towers of Hanoi problem solved in Fiji.
// Another classic recursion problem.
//
// Note below that I use "{ -- }" for the stack comment.
// This is not actually a stack comment--it is live code,
// declaring a list of arguments!


// "{" creates a local "value" for each argument, and
// sets it to the its corresponding value popped from the
// stack.  (It pops them off in stack comment order; thus
//		: hanoi-move { targetpeg srcpeg -- }
// creates a local value called "srcpeg" and sets it to
// the top stack argument, then creates a second local
// value called "targetpeg" and sets it to the next stack
// argument, etc.  These arguments work even in recursive
// calls.

// "}" ends the list of local variables.  Everything between
// the "--" (if specified) and the "}" is ignored.



: hanoi-move { targetpeg srcpeg -- }
	."-- move ring from " srcpeg . ."to " targetpeg .. cr
	;



: hanoi-recurse { sparepeg targetpeg srcpeg rings -- }

	rings 1 !=
	dup // leave this result on the stack for the bottom if

	if
		// move rings-1 rings from srcpeg to sparepeg
		targetpeg sparepeg srcpeg rings 1-  recurse
	endif

	targetpeg srcpeg hanoi-move

	if
		// move rings-1 rings from sparepeg to targetpeg
		srcpeg targetpeg sparepeg rings 1-  recurse
	endif
	;



: _hanoi	{ sparepeg targetpeg srcpeg rings -- }
	."** Tower of Hanoi solved for " rings . ."rings, "
	."stack starts on " srcpeg .
	."and ends on " targetpeg .. .": **" cr
	sparepeg targetpeg srcpeg rings hanoi-recurse 
	cr
	;



: hanoi		( rings -- )
	2 3 1  3 roll
	_hanoi ;


// let 'er rip!
2 hanoi
1 2 3 3 _hanoi
4 hanoi

bye
