// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// enhancements.f
//
// Here are words that are Fiji-specific.

// A Fiji "prefix" is a word that can be broken off the front of
// another word.  In classical Forth, ALL words were distinguished
// with a trailing space, including
//		(
// and
//		."
// This meant that to print the string "hello there", you had to run
//		." hello there"
// and to print the string " hello there" (one leading space), you had to run
//		."  hello there"
// Consistent, sorta, and definitely ugly.  A pet peeve of mine.
//
// So, in Fiji, ( and ." and so on are "prefix" words.  If the Fiji
// interpreter runs across a word it doesn't recognize at all, as a last
// measure it'll see if the word begins with an acceptable prefix.  If it
// does, Fiji will break off the prefix and evaluate that.  Prefixes are
// meant for parsing words--words that will start removing tokens from
// the input stream.

// This is just a demonstration of prefixes--the new word ~ doesn't really
// do anything useful.
."a new prefix!"
	: ~ ."<< called ~>>" ;
	"~" addprefix ~35 .
	cr

// A quick demonstration of pulling strings from the input stream:
nextnonwhitetoken howdy-there
dup >class .
."got the token ->" . ."<-" cr

// Also see the files "inline.f", "numbers.f",
// and "string.f" for more Fiji-specific words.