// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// fib.f
//
// Fibonacci number generator.  The classic demonstration of recursion.
//
// This file also demonstrates a begin/while/repeat loop.

: _fib	( n -- )
					( n )
	dup 2 <=		( n n<=2 )
	if				( n )
		drop 		(  )
		1			( 1 )
	else			( n )
		1 -
		dup			( n n )
		recurse		( fib-n n )
		swap		( n fib-n )
		1 -			( n-1  fib-n )
		recurse		( fib-n-1 fib-n )
		+			( sum )
	endif
	;

."okay, now I'm showing off.  RECURSION _and_ LOOPING:" cr
: fib dup _fib swap ."fibbonacci sequence number " . ."is " . cr ;
: testfib 0 begin 1 + dup 10 <= while dup fib repeat ;
testfib

// wanna see something really scary?
// see testfib
// see _fib

