// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// doloop.f
//
// The "do-loop" is probably the most often used looping construct
// in Forth.
//
//  do  ( end-index start-index -- )
//    Takes two arguments off the stack and prepares for looping.
//  loop ( -- )
//    Adds one to the index and jumps back to the most recent "do".
//  +loop ( increment -- )
//	  Adds increment to the index and jumps back to the most recent "do".
//  leave ( -- )
//    Leaves the current do/loop set.  Equivalent to "break" in C / Java.
//  i ( -- current-loop-index )
//	j ( -- parent-loop-index )
//	k ( -- grandparent-loop-index )
//	  i returns the current loop index for a loop.  If the current loop
//    is nested, "j" will return the loop index for the parent loop, and
//    "k" for the loop outside that one.  (Any further than that, and
//    you should save it off to a variable.)
//
// Besides a "leave", the loop actually ends when the loop index
// crosses the line between end-index and (end-index - 1).  So
//		10 0 do ... loop
// will stop after running through with i == 9, and
//		-10 0 do ... -1 +loop
// will stop after running through with i == -10 (when I crosses 
// between -10 and (-10 - 1), or -11).  This works fine with large
// increments:
//		10 0 do ... 880 +loop
// will stop after one loop.


: testloop 10 0 do ."doing loop #" i . cr loop ."done looping!" cr ;
testloop

: testbeginuntil 10 begin 1 - dup dup ."Only " . ."more to go!" cr 1 = until ."Done!" cr ;
testbeginuntil

: testloop 10 10 ?do ."you shouldn't see this!" loop ."this is fine." cr  ;
testloop

: testloop  10 0 ?do ."doing loop #" i . cr loop ."done looping!" cr ;
testloop

: testloop  50 0  ?do i . 5 +loop ."done looping!" cr ;
testloop

: testloop 32768 1  ?do i . i +loop ."done looping!" cr ;
testloop

: testloop 0 5000 > if 1 then  ;
testloop

: testloop 32768 1  ?do i 5000 > if leave then i . i +loop ."done looping!" cr ;
testloop


: percentage  * 100.0 / ;

: doubled ( amount interest -- )
	swap >float 21 1 do
		cr
		."Year" i 4 .r ."   "
		2dup percentage +
		."balance " dup >integer 5 .r dup 2000 >
		if
			cr
			."more than doubled in " i . ."years." leave
		then
	loop
	2drop
	;

1000 6 doubled

: table
	cr
	11 1 do
		11 1 do
			i j * dup
			40 >= if drop leave endif
			.
			loop
		cr
		i 6 > if leave endif
		loop
	;

table

: falling -10 0 do ."counting down... " i . cr -1 +loop ."done!" cr ;
falling

: fallingfaster -100 -1 do ."counting down... " i . cr i +loop ."done!" cr ;
fallingfaster
