// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// doer.f
//
// Leo Brodie proposed a method of vectored execution for Forth
// in "Thinking Forth".  Vectored execution is a fancy name for
// function pointers--well, that's what a C programmer would call
// it.  doer/make is a little different from that.
//
// At its core, "doer" declares a do-er, a function pointer.
// "make X a b c" makes the doer X run "a b c" when X is executed.
// most of the time, "make" is run from inside a function, in which
// case you can simply end the function as normal.  if you want to
// continue processing "after" the make, use ";and" as demonstrated
// below.  If you run "make" outside of a colon definition, you must
// end it with ";make", as shown below.

// You can also chain "make"s together.  This is excellently demonstrated
// by the "recital" example at the end of this file.

doer joe
: testjoe ."running joe: ->" joe ."<-" cr ;
testjoe

: test ."making joe do stuff... " make joe ."howdy"  make joe ."hidey-ho!" 
 ;and ."done with test." cr
 ;
: test2 ."making joe do more stuff... " make joe ."hey there!"  make joe ."well, hello!" 
 ;and ."done with test2." cr
 ;

test
testjoe
testjoe
testjoe
test2
testjoe
testjoe
testjoe
make joe ."g'day, mate!"  ;make
testjoe
testjoe

doer why?
: recital
	make why? ."To change the light bulb." cr
	begin
		make why? ."Because it's burned out." cr
		make why? ."Because it was old." cr
		make why? ."Because we put it in there a long time ago." cr
		make why? ."Because it was dark!" cr
		make why? ."Because it was night time!!!" cr
		make why? ."Stop saying WHY!" cr
		make why? ."Because it's driving me crazy!" cr
		make why? ."Just let me change this light bulb!" cr
	false until
	;and
	cr ."Your daddy is standing on the table.  Ask him 'why?'." cr
	;

: why? cr why? ;
recital
why?
why?
why?
why?
why?
why?
why?
why?
why?
why?
why?
why?

bye