// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// create.f
//
// Create creates a variable in Forth, which is really
// more like a C pointer than anything else.  (Which means
// that every variable can be an array.)  A word
// created with "create" will push its own address on
// the stack when it is referenced.
// Initially, the "created" word has no storage; you must
// create storage either with "allot" or ",".
//
// allot ( objects-to-reserve -- )
//   Adds space for "objects-to-reserve" to the most
//   recently created word.
// , ( object-to-add -- )
//   Adds "object-to-add" to the end of the most recently
//   created word.
// ! ( object pointer -- )
//   Stores object into pointer.
// @ ( pointer -- object-at-pointer )
//   Fetches the value of pointer and pushes it on the stack.
// 
// So how do you use a variable as an array?  Add or subtract
// from it after pushing it on the stack.
//   C:              Forth:
//   foo[0] = a      a foo !
//   foo[1] = a      a foo 1+ !
//   foo[b] = a      a foo b + !

."trying create: 81, 15, 127 == " 
	create foo 81 , 127 ,
	foo @ .
	15 foo ! foo ?
	foo 1 + ?
	cr

."trying variable: 55 == " 
	variable foo-variable
	55 foo-variable !
	foo @ .
	cr


create bar 5 allot 127 bar 3 + ! bar 3 + ?
cr

//
// Here we come to one of the most powerful words
// in Forth: 
//
//  does>
//
// What does does> do?  Glad you asked.  Does>
// changes the most recently created word so it
// executes the code that appears after the "does>"
// in the current compiling word.  You generally
// use create when you use does>.  A create/does>
// created word pushes its own address onto the
// stack before it runs the does> code.
//
// Perhaps it's easier to show you:

: addn create , does> @ + ;

// This line creates a new word called "addfourty",
// which when run first pushes its own address on
// the stack (which contains 40), and then executes
// "@ +", which looks up that 40 and pushes it on
// the stack, and then adds it to the previous top
// stack item.
40 addn addfourty 
// As you're guessing, this prints 169.
129 addfourty .
cr

create foo 81 , 127 , ;;
see foo
cr