// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// condcomp.f
//
// Demonstration of conditional compilation in Fiji.
//
// Conditional compilation is a technique 


// First, classical Forth-style conditional compilation.
// 

true value flag

: flag\   flag not  if  postpone \  endif ; immediate
: !flag\  flag      if  postpone \  endif ; immediate

."test of postpone with classical conditional compilation:"
cr

: testflag1
	flag\ ."flag must be false!" cr
	!flag\ ."flag must be true!" cr
	cr
	;
testflag1
// testflag1

false to flag

: testflag1
	flag\ ."flag must be false!" cr
	!flag\ ."flag must be true!" cr
	cr
	;
testflag1
// testflag1


// ANS Forth defined a new conditional compilation technique:
// [if] / [else] / [then]
// These work like if/else/then, except the flag is read off
// the stack at runtime, and code that is if'd out won't even
// be compiled.
//
// In Fiji, [endif] is a synonym for [then].

."got here 1" cr

: testconditionalcompilation
	[ 0 ]
	[if] ."yes"
	[else] ."no"
	[endif]
	cr
;

."got here 2" cr

testconditionalcompilation

."got here 3" cr

: testconditionalcompilation2
	[ 1 ]
	[if] ."yes"
	[else] ."no"
	[endif]
	cr
;

."got here 4" cr

testconditionalcompilation2

