// This file is part of Fiji, Copyright 1998 by Larry Hastings
// See http://www.midwinter.com/~lch/programming/fiji/ for full source and license.

//
// colon.f
//
// Colon (":") defines a new "word".  "Word" is the Forth nomenclature for
// a subroutine.  The colon is followed by the name of the new word,
// and then the list of words to be compiled into the new word.
// 
// Colon definitions are ended with a semicolon (";").

// This line defines a new word called "addfour", which takes the top
// stack argument and adds four to it, leaving the result on the stack.
: addfour 4 + ;

."addfour: 39 45.0 == "
35 addfour . 41.0 addfour .
cr

// This line defines a new word called "addninteen", which takes the top
// stack argument and adds four to it, leaving the result on the stack.
: addnineteen 19 + ;

."defining addnineteen... 54 == " 
	35 addnineteen .
	cr

// An "immediate" word is a word that gets run, rather than compiled, when
// it is referenced while compiling another word.  you can use immediate
// words for a great many uses, including making your own compiling words.

// here is an immediate word.  "42 literal" pushes a 42 onto the stack
// at runtime, and "literal" removes the top stack item and compiles it
// into the currently being-defined word.  Therefore, compile-fourty-two
// has the same effect as just saying "42", with the side-effect of the
// ." statement.
: compile-fourty-two ."<<called compile-fourty-two!>>" 42 literal ; immediate
: addfourty-two compile-fourty-two + ;

."trying immediate: 59 == " 
	17 addfourty-two . 
	119 addfourty-two . 
cr

// To learn more about compile-time versus run-time in Fiji, read condcomp.f.