/*
** [BEGIN NOTICE]
**
** Copyright (C) 1998 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The Fiji homepage is here:
**		http://www.midwinter.com/~lch/programming/fiji/
**
** [END NOTICE]
*/

import Fiji.*;
import java.util.Hashtable;

//
// A "word" in Forth lingo means a dictionary entry.
// This is unrelated to the "byte"/"word"/"dword" variety.

public class FijiWord extends Object
	{
	public String 		name;
	public boolean		immediate;
	public boolean		inline;

	public FijiWord		previous; // previous entry in dictionary
	public boolean		smudged; // if TRUE, we ignore this entry and use previous

	public FijiPointer	CFA;	// "code field address"
	public FijiPointer	PFA;	// "parameter field address"

	public static FijiPointer	doVariable = new FijiPointer();
	public static FijiPointer	nullPFA = new FijiPointer();

	void init()
		{
		CFA = doVariable;
		PFA = nullPFA;
		}

	public FijiWord()
		{
		init();
		}

	public FijiWord(String n)
		{
		init();
		name = n;
		}

	public FijiWord copy()
		{
		FijiWord rv = new FijiWord();
		rv.name = name;
		rv.immediate = immediate;
		rv.previous = previous;
		rv.CFA = CFA.copy();
		rv.PFA = PFA.copy();
		return rv;
		}

	public FijiPointer toCFA()
		{
		return CFA;
		}

	public FijiPointer toPFA()
		{
		return PFA;
		}

	public void execute(FijiInterpreter i)
		{
		i.push(PFA.copy());

		FijiPointer newCFA = CFA.copy();
		newCFA.execute(i);
		}

	public String toString()
		{
		return new String(
			"FijiWord@" + Integer.toString(hashCode())
			+ " \"" + name + "\" ("
			+ (immediate ? "" : "not ")  + "immediate, "
			+ (inline ? "" : "not ")  + "inline)"
			);
		}

	}

