/*
** [BEGIN NOTICE]
**
** Copyright (C) 1998 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The Fiji homepage is here:
**		http://www.midwinter.com/~lch/programming/fiji/
**
** [END NOTICE]
*/

import Fiji.*;
import java.lang.reflect.*;

//
//
// If you want to call a constructor/method that uses native types
// for a parameter or a return value, you should specify that parameter
// with the equivalent java.lang class (int -> java.lang.Integer, etc).
// This code will still find the appropriate constructor/method, and
// meanwhile it makes conversion to/from objects easier on me.


// NEEDSWORK: handle array types in any of these

public class FijiReflect extends FijiPointer
	{
 	static final boolean debugPrintStatus = false; // true; 

	public Object o;
	public Method m;
	public String mName;
	public String[] mArguments;
	public Object[] oArray;
	public Class returnClass;

	public FijiReflect()
		{
		super();
		}

	public FijiReflect(FijiReflect x)
		{
		super(x);
		o = x.o;
		m = x.m;
		mName = x.mName;
		mArguments = x.mArguments;
		oArray = x.oArray;
		returnClass = x.returnClass;
		}

	public FijiPointer copy()
		{
		return new FijiReflect(this);
		}

	static String getPrimitiveWrapperClass(Class primitiveClass)
		{
		String primitive = primitiveClass.getName();

		if (primitive.compareTo("int") == 0)
			return "java.lang.Integer";
		if (primitive.compareTo("long") == 0)
			return "java.lang.Long";
		if (primitive.compareTo("char") == 0)
			return "java.lang.Character";
		if (primitive.compareTo("byte") == 0)
			return "java.lang.Byte";
		if (primitive.compareTo("short") == 0)
			return "java.lang.Short";
		if (primitive.compareTo("boolean") == 0)
			return "java.lang.Boolean";
		if (primitive.compareTo("double") == 0)
			return "java.lang.Double";
		if (primitive.compareTo("float") == 0)
			return "java.lang.Float";
		if (primitive.compareTo("void") == 0)
			return "java.lang.Void";
		return null;
		}

	static Constructor findConstructor(Class c, String[] wantParameters)
		{
		Constructor[] constructors = c.getDeclaredConstructors();
		boolean passed;

		passed = false;
		int i;
		for (i = 0; (passed == false) && (i < constructors.length); i++)
			{
			if (debugPrintStatus)
				System.out.println("findConstructor try #" + i + ":"); 

			Class hasParameters[] = constructors[i].getParameterTypes();

			// has to have the same number of parameters
			// NEEDSWORK: wantParameters should be able to be "null" if we want 0 parameters
			if (hasParameters.length != wantParameters.length)
				{
				if (debugPrintStatus)
					System.out.println("this method has " + hasParameters.length + " parameters but we want " + wantParameters.length + " parameters.  next!"); 
				continue;
				}

			// if we want zero parameters, and found it, we're done
			if (hasParameters.length == 0)
				{
				passed = true;
				break;
				}

			// each parameter has to be the same type
			// (specified as the constructor objects themselves)
			passed = true;
			for (int j = 0; j < hasParameters.length; j++)
				{
				Class has = hasParameters[j];
				String want = wantParameters[j];
				// if it's not the same class
				if ((want.compareTo(has.getName()) != 0)
					// and it's either not a primitive class
					&& (!has.isPrimitive()
						// or it _is_ a primitive class but it's not the same class
						|| (want.compareTo(getPrimitiveWrapperClass(hasParameters[j])) != 0)))
//				Object want = wantParameters[j];
//				if ((!has.isInstance(want))
//					&& (!has.isPrimitive()
//						|| getPrimitiveWrapperClass(hasParameters[j]).isInstance(want)))
					{
					if (debugPrintStatus)
						System.out.println("parameter " + j + " should be type " + want + " but this one has " + has.getName() + " so it's not a match.  next!");
					passed = false;
					}
				}
			if (passed)
				break;
			}

		if (passed)
			{
			if (debugPrintStatus)
				System.out.println("found it!: " + constructors[i]);
			return constructors[i];
			}

		// NEEDSWORK: use exception handling
		if (debugPrintStatus)
			System.out.println("tried" + i + " constructors, all failed, returning null.");
		return null;
		}
		

	static Method findMethod(Class c, String methodName,
		String[] methodParameters, String methodReturnClass)
		{
		Method[] methods = c.getDeclaredMethods();
		boolean passed;

		passed = false;
		int i;
		for (i = 0; (passed == false) && (i < methods.length); i++)
			{
			passed = true;

			if (debugPrintStatus)
				System.out.println("findMethod try #" + i + ":"); 
			// name has to match
			if (methodName.compareTo(methods[i].getName()) != 0)
				{
				if (debugPrintStatus)
					System.out.println("name doesn't match, no good."); 
				passed = false;
				continue;
				}
			
			Class returnClass = methods[i].getReturnType();
			if (debugPrintStatus)
				System.out.println("returnclass is " + returnClass.getName() 
					+ ", we want " + methodReturnClass);
			if ((returnClass.getName().compareTo(methodReturnClass) != 0)
				&& (!returnClass.isPrimitive()
					|| (getPrimitiveWrapperClass(returnClass).compareTo(methodReturnClass) != 0)))
				{
				if (debugPrintStatus)
					System.out.println("return values don't match, no good."); 
				passed = false;
				continue;
				}

			Class hasParameters[] = methods[i].getParameterTypes();

			// if this method has no parameters
			if (hasParameters.length == 0) 
				{
				// and the method we want has no parameters, we're done
				if ((methodParameters == null)
				    || (0 == methodParameters.length))
					break;
				// oops, we want parameters, keep going
				if (debugPrintStatus)
					System.out.println("this method has no arguments, but we want some.  nope."); 
				passed = false;
				continue;
				}

			// okay, this method has at least one parameter.
			// if we don't want any, or if we want a different
			// number of parameters, this isn't it.
			if ((methodParameters == null)
				|| (hasParameters.length != methodParameters.length))
				{
				if (debugPrintStatus)
					System.out.println("wrong number of arguments, nope."); 
				passed = false;
				continue;
				}

			// each parameter has to be the same type (specified by strings)
			for (int j = 0; j < hasParameters.length; j++)
				{
				Class has = hasParameters[j];
				String want = methodParameters[j];
				if (debugPrintStatus)
					System.out.println("here in findMethod, hasParameters[j].getName() is \"" + hasParameters[j].getName() + "\" and methodParameters[j] is \"" + methodParameters[j] + "\"");
				if ((want.compareTo(has.getName()) != 0)
					&& (!has.isPrimitive()
						|| (want.compareTo(getPrimitiveWrapperClass(has)) != 0)))
					{
					if (debugPrintStatus)
						System.out.println("that one failed, this method isn't it.");
					passed = false;
					break;
					}
				}
			if (passed)
				break;
			}

		if (passed)
			{
			if (debugPrintStatus) 
				System.out.println("found a method!: " + methods[i]);
			return methods[i];
			}

		// NEEDSWORK: use exception handling
		return null;
		}
		

	public FijiReflect(String className,
		Object[] constructorArguments,
		String methodName,
		String[] methodArguments,
		String methodReturnClass)
		{
//		Class c;
//		// NEEDSWORK: use exception handling
//		try
//			{
//			c = Class.forName(className);
//			}
//		catch (ClassNotFoundException e)
//			{
//			if (debugPrintStatus)
//				System.out.println("methodreflect.constructor ClassNotFoundException exception: " + e.getMessage());
//			return;
//			}
////		Constructor constructor = findConstructor(c, constructorArguments);
//		// NEEDSWORK: use exception handling
//		m = findMethod(c, methodName, methodArguments, methodReturnClass);
//		mArguments = new String[methodArguments.length];
//		java.lang.System.arraycopy(methodArguments, 0, mArguments, 0, methodArguments.length);
//		mName = methodName;
//		oArray = new Object[methodArguments.length];
//
//		try
//			{
//			returnClass.forName(methodReturnClass);
//			}
//		catch (ClassNotFoundException e)
//			{
//			if (debugPrintStatus)
//				System.out.println("methodreflect.constructor ClassNotFoundException exception 2: " + e.getMessage());
//			return;
//			}
//
//		try
//			{
//			o = constructor.newInstance(constructorArguments);
//			}
//		catch (InstantiationException e)
//			{
//			if (debugPrintStatus)
//				System.out.println("methodreflect.constructor InstantiationException exception: " + e.getMessage());
//			return;
//			}
//		catch (IllegalAccessException e)
//			{
//			if (debugPrintStatus)
//				System.out.println("methodreflect.constructor IllegalAccessException exception: " + e.getMessage());
//			return;
//			}
//		catch (InvocationTargetException e)
//			{
//			if (debugPrintStatus)
//				System.out.println("methodreflect.constructor InvocationTargetException exception: " + e.getMessage());
//			return;
//			}
		}

	public void execute(FijiInterpreter fi)
		{
//		boolean failed = false;
//		Class c;
//
//		fi.pop(); // remove our PFA
//
//		for (int i = 0; i < mArguments.length; i++)
//			{
//			if (debugPrintStatus)
//				System.out.println("stack arg " + i + " is type " + fi.pick(i).getClass().getName()
//					+ ", argument type we want is " + mArguments[i]);
//			if (fi.pick(i).getClass().getName().compareTo(mArguments[i]) != 0)
//				{
//				if (debugPrintStatus)
//					System.out.println("FijiReflect on " + mName + " failed--arguments don't match stack contents.");
//				failed = true;
//				break;
//				}
//			oArray[i] = fi.pick(i);
//			}
//
//		// we wait until all the arguments translated properly to pop them
//		for (int i = 0; i < mArguments.length; i++)
//			fi.pop();
//
//		if (failed)
//			{
//			if (debugPrintStatus)
//				System.out.println("FijiReflect on " + mName + " failed.");
//			return;
//			}
//
//		Object returned;
//		try
//			{
//			returned = m.invoke(o, oArray);
//			}
//		catch (InvocationTargetException e)
//			{
//			if (debugPrintStatus)
//				System.out.println("methodreflect.execute() exception: " + e.getMessage());
//			return;
//			}
//		catch (IllegalAccessException e)
//			{
//			if (debugPrintStatus)
//				System.out.println("methodreflect.execute() exception: " + e.getMessage());
//			return;
//			}
//
//		if (returned == null)
//			return;
//
//		// push return value on the stack
//		fi.push(returned);
		}

	public String toString()
		{
		return new String("FijiReflect@" + Integer.toString(hashCode())
			+ "(executes method " + mName + " on object " + o + ")");
		}
	}

