/*
** [BEGIN NOTICE]
**
** Copyright (C) 1998 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The Fiji homepage is here:
**		http://www.midwinter.com/~lch/programming/fiji/
**
** [END NOTICE]
*/

import Fiji.*;

public class FijiPointer extends Object
	{
	public byte[]		bytes;
	public int			byteX;

	public Object[]		objects;
	public int			objectX;

	public FijiDictionary locals;
	public int			localCount;

	static long nextSerialNumber = 0;
	long serialNumber;

	synchronized void init()
		{
		serialNumber = nextSerialNumber++;
		}

	public void set(byte[] newBytes, Object[] newObjects)
		{
		if (newBytes != null)
			bytes = newBytes;
		if (newObjects != null)
			objects = newObjects;
		}


	public FijiPointer()
		{
		init();
		}

	public FijiPointer(FijiPointer Program)
		{
		init();
		bytes = Program.bytes;
		byteX = Program.byteX;

		objects = Program.objects;
		objectX = Program.objectX;

		// please don't change the locals
		locals = Program.locals;
		localCount = Program.localCount;
		}

	public FijiPointer(byte[] bytes)
		{
		init();
		set(bytes, null);
		}

	public FijiPointer(byte[] bytes, Object[] objects)
		{
		init();
		set(bytes, objects);
		}

	public FijiPointer copy()
		{
		FijiPointer returnValue = new FijiPointer(this);
		returnValue.serialNumber = this.serialNumber;
		return returnValue;		
		}

	public String toString()
		{
		return new String(
//			"FijiPointer@" + Integer.toString(hashCode())
			"FijiPointer #" + serialNumber
			+ " (on " + byteX
				+ " of " + ((bytes == null) ? -1 : bytes.length)
				+ " bytes"
			+ ", on " + objectX
				+ " of " + ((objects == null) ? -1 : objects.length)
				+ " objects)");
		}

	void pushLocals(FijiInterpreter fi)
		{
		if (localCount != 0)
			{
			// FORTH locals are designed to be move'd to the locals stack,
			// not pushed/popped... so we have to preserve the same order
			for (int i = localCount - 1; i >= 0; i--)
				fi.pushLocal(fi.pick(i));
			for (int i = 0; i < localCount; i++)
				fi.pop();
			fi.pushLocal(new Integer(localCount));
			}
		}

	public void execute(FijiInterpreter i)
		{
		}

	public void addArgument(Object Argument)
		{
		Object NewObjects[] = new Object[objects.length + 1];
		int i;
		for (i = 0; i < objects.length; i++)
			{
			NewObjects[i] = objects[i];
			}
		NewObjects[i] = Argument;
		objects = NewObjects;
		}

//	public void addArgument(char Argument)
//		{
//		FijiObject thing = new FijiObjectCharacter(Argument);
//		addArgument(thing);
//		}
//
//	public void addArgument(int Argument)
//		{
//		FijiObject thing = new FijiObjectInteger(Argument);
//		addArgument(thing);
//		}
//
//	public void addArgument(double Argument)
//		{
//		FijiObject thing = new FijiObjectDouble(Argument);
//		addArgument(thing);
//		}
//
//	public void addArgument(String Argument)
//		{
//		FijiObject thing = new FijiObjectString(Argument);
//		addArgument(thing);
//		}
//
//	public void addArgument(FijiObjectProgram Argument)
//		{
//		FijiObject thing = new FijiObjectProgram(Argument);
//		addArgument(thing);
//		}
	}
