/*
** [BEGIN NOTICE]
**
** Copyright (C) 1998 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The Fiji homepage is here:
**		http://www.midwinter.com/~lch/programming/fiji/
**
** [END NOTICE]
*/

import Fiji.*;
import java.util.Enumeration;
import java.util.Hashtable;

//
// A "word" in Forth lingo means a dictionary entry.
// This is unrelated to the "byte"/"word"/"dword" variety.

public class FijiDictionary extends Object
	{
	Hashtable ht;

	public FijiDictionary()
		{
		ht = new Hashtable(100, (float)0.6); // pretty arbitrary, really
		}

	public FijiWord lookup(String wordname)
		{
		FijiWord x = (FijiWord)ht.get(wordname.toLowerCase());

		while ((x != null) && x.smudged)
			x = x.previous;

		return x;
		}

	public void add(FijiWord word)
		{
		FijiWord previous = (FijiWord)ht.put(word.name.toLowerCase(), word);
		if (previous != null)
			word.previous = previous;
		}

	public void forget(String wordname)
		{
		FijiWord x = (FijiWord)ht.get(wordname.toLowerCase());
		if (x.previous != null)
			ht.put(wordname.toLowerCase(), x.previous);
		else
			ht.remove(wordname.toLowerCase());
		}

	public String toString()
		{
		String rv = super.toString() + "(" + ht.size()
			+ ((ht.size() == 1) ? " entry: " : " entries: ");

		Enumeration e = ht.keys();
		boolean addComma = false;

		while (e.hasMoreElements())
			{
			if (addComma)
				rv += ", ";
			rv += (String)e.nextElement();
			addComma = true;
			}

		return rv + ")";
		}
	}

