/*
** [BEGIN NOTICE]
**
** Copyright (C) 1998 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The Fiji homepage is here:
**		http://www.midwinter.com/~lch/programming/fiji/
**
** [END NOTICE]
*/

import Fiji.*;

public class FijiCallFrame extends FijiPointer
	{
	// what is the associated operand with this frame?
	public byte	operand;
	// how many objects up the stack must you go
	// to find the next CallFrame?
	public int 		depth;

	public FijiCallFrame(FijiPointer p)
		{
		super(p);
		}

	public FijiCallFrame(FijiCallFrame f)
		{
		super(f);
		operand = f.operand;
		depth = f.depth;
		}

	public FijiPointer copy()
		{
		return new FijiCallFrame(this);
		}

	public String toString()
		{
		return new String(
			"FijiCallFrame@" + Integer.toString(hashCode())
			+ ", operand \"" + operand + "\" depth " + depth
			+ " (" + super.toString() + ")");
		}
	}
