/*
 * Decompiled with CFR 0.152.
 */
public class FijiPointer {
    public byte[] bytes;
    public int byteX;
    public Object[] objects;
    public int objectX;
    public FijiDictionary locals;
    public int localCount;
    static long nextSerialNumber;
    long serialNumber;

    synchronized void init() {
        this.serialNumber = nextSerialNumber++;
    }

    public void set(byte[] byArray, Object[] objectArray) {
        if (byArray != null) {
            this.bytes = byArray;
        }
        if (objectArray != null) {
            this.objects = objectArray;
        }
    }

    public FijiPointer() {
        this.init();
    }

    public FijiPointer(FijiPointer fijiPointer) {
        this.init();
        this.bytes = fijiPointer.bytes;
        this.byteX = fijiPointer.byteX;
        this.objects = fijiPointer.objects;
        this.objectX = fijiPointer.objectX;
        this.locals = fijiPointer.locals;
        this.localCount = fijiPointer.localCount;
    }

    public FijiPointer(byte[] byArray) {
        this.init();
        this.set(byArray, null);
    }

    public FijiPointer(byte[] byArray, Object[] objectArray) {
        this.init();
        this.set(byArray, objectArray);
    }

    public FijiPointer copy() {
        FijiPointer fijiPointer = new FijiPointer(this);
        fijiPointer.serialNumber = this.serialNumber;
        return fijiPointer;
    }

    public String toString() {
        return new String("FijiPointer #" + this.serialNumber + " (on " + this.byteX + " of " + (this.bytes == null ? -1 : this.bytes.length) + " bytes" + ", on " + this.objectX + " of " + (this.objects == null ? -1 : this.objects.length) + " objects)");
    }

    void pushLocals(FijiInterpreter fijiInterpreter) {
        if (this.localCount != 0) {
            int n = this.localCount - 1;
            while (n >= 0) {
                fijiInterpreter.pushLocal(fijiInterpreter.pick(n));
                --n;
            }
            int n2 = 0;
            while (n2 < this.localCount) {
                fijiInterpreter.pop();
                ++n2;
            }
            fijiInterpreter.pushLocal(new Integer(this.localCount));
        }
    }

    public void execute(FijiInterpreter fijiInterpreter) {
    }

    public void addArgument(Object object) {
        Object[] objectArray = new Object[this.objects.length + 1];
        int n = 0;
        while (n < this.objects.length) {
            objectArray[n] = this.objects[n];
            ++n;
        }
        objectArray[n] = object;
        this.objects = objectArray;
    }
}

