/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FijiInterpreter {
    public FijiPointer program;
    public FijiDictionary dictionary;
    public static FijiDictionary globalDictionary;
    boolean noByeYet = true;
    static FijiPointer doVariable;
    static FijiPointer doLocal;
    static FijiPointer doColon;
    static FijiPointer doDoes;
    Vector DS = new Vector();
    Vector RS = new Vector();
    Vector CS = new Vector();
    Vector LS = new Vector();
    boolean creating = false;
    boolean compiling = false;
    FijiWord newWord;
    boolean postponeNext;
    FijiWord postponedWord;
    FijiPointer doesProgram;
    Vector bytes;
    Vector objects;
    static final byte INVALID = -127;
    static final byte STRING = -126;
    static final byte POINTER = -125;
    static final byte METHOD = -124;
    static final byte DOUBLE = -123;
    static final byte FLOAT = -122;
    static final byte LONG = -121;
    static final byte INTEGER = -120;
    static final byte SHORT = -119;
    static final byte BYTE = -118;
    static final byte CHARACTER = -117;
    static final byte BOOLEAN = -116;
    static final byte TO_CLASS = -115;
    static final byte TO_BODY = -114;
    static final byte TO_CFA = -113;
    static final byte CALL = -112;
    static final byte EXIT = -111;
    static final byte EXECUTE = -110;
    static final byte INTERNAL_STOP = -109;
    static final byte JUMP = -108;
    static final byte JUMP_CHECK = -107;
    static final byte BRANCH0 = -106;
    static final byte BRANCH0_CHECK = -105;
    static final byte JUMP_BACKWARD_PUSH = -104;
    static final byte JUMP_FORWARD_PUSH = -103;
    static final byte JUMP_BACKWARD_FIXUP = -102;
    static final byte JUMP_FORWARD_FIXUP = -101;
    static final byte CS_ROLL = -100;
    static final byte CS_PICK = -99;
    static final byte TO_CS = -98;
    static final byte CS_FROM = -97;
    static final byte DO = -96;
    static final byte QUESTION_DO = -95;
    static final byte I = -94;
    static final byte J = -93;
    static final byte K = -92;
    static final byte LEAVE = -91;
    static final byte I_LEAVE = -90;
    static final byte I_LEAVE_CHECK = -89;
    static final byte LOOP = -88;
    static final byte I_LOOP = -87;
    static final byte I_LOOP_CHECK = -86;
    static final byte PLUS_LOOP = -85;
    static final byte I_PLUS_LOOP = -84;
    static final byte I_PLUS_LOOP_CHECK = -83;
    static final byte I_PREP_DO = -82;
    static final byte I_DO = -81;
    static final byte I_DO_CHECK = -80;
    static final byte I_QUESTION_DO = -79;
    static final byte I_QUESTION_DO_CHECK = -78;
    static final byte ADD = -77;
    static final byte SUBTRACT = -76;
    static final byte MULTIPLY = -75;
    static final byte DIVIDE = -74;
    static final byte MOD = -73;
    static final byte SHIFT_LEFT = -72;
    static final byte SHIFT_RIGHT = -71;
    static final byte SHIFT_RIGHT0 = -70;
    static final byte BINARY_AND = -69;
    static final byte BINARY_OR = -68;
    static final byte BINARY_XOR = -67;
    static final byte BOOLEAN_AND = -66;
    static final byte BOOLEAN_OR = -65;
    static final byte BOOLEAN_XOR = -64;
    static final byte LESS_THAN = -63;
    static final byte LESS_THAN_EQUALS = -62;
    static final byte EQUALS = -61;
    static final byte GREATER_THAN_EQUALS = -60;
    static final byte GREATER_THAN = -59;
    static final byte NOT_EQUAL_TO = -58;
    static final byte NOT = -57;
    static final byte DROP = -56;
    static final byte DUP = -55;
    static final byte QUESTION_DUP = -54;
    static final byte SWAP = -53;
    static final byte ROT = -52;
    static final byte PUSH = -51;
    static final byte LITERAL = -50;
    static final byte ROLL = -49;
    static final byte PICK = -48;
    static final byte DEPTH = -47;
    static final byte TO_R = -46;
    static final byte R_FROM = -45;
    static final byte R_FETCH = -44;
    static final byte QUOTE = -43;
    static final byte DOT_QUOTE = -42;
    static final byte NEXT_TOKEN = -41;
    static final byte NEXT_NONWHITE_TOKEN = -40;
    static final byte MORE_TOKENS = -39;
    static final byte PUT_BACK_TOKEN = -38;
    static final byte STRICMP = -37;
    static final byte STRTOK = -36;
    static final byte SUBSTR = -35;
    static final byte POPCHAR = -34;
    static final byte ALLOT = -33;
    static final byte COMMA = -32;
    static final byte FETCH = -31;
    static final byte TO_LENGTH = -30;
    static final byte STORE = -29;
    static final byte C_ALLOT = -28;
    static final byte C_COMMA = -27;
    static final byte C_FETCH = -26;
    static final byte C_TO_LENGTH = -25;
    static final byte C_STORE = -24;
    static final byte C_PLUS = -23;
    static final byte C_MINUS = -22;
    static final byte BODY_STORE = -21;
    static final byte CFA_STORE = -20;
    static final byte DOES_SET_CFA = -19;
    static final byte COLON = -18;
    static final byte COLON_PRIME = -17;
    static final byte SEMICOLON = -16;
    static final byte CREATE = -15;
    static final byte CREATE_PRIME = -14;
    static final byte FINALIZE = -13;
    static final byte LEFT_SQUARE = -12;
    static final byte RIGHT_SQUARE = -11;
    static final byte STATE_QUESTION = -10;
    static final byte POSTPONE = -9;
    static final byte HANDLE_POSTPONED_WORD = -8;
    static final byte HANDLE_POSTPONED_BYTECODE = -7;
    static final byte IMMEDIATE = -6;
    static final byte INLINE = -5;
    static final byte TICK = -4;
    static final byte TICK_PRIME = -3;
    static final byte COMPILE_BYTE = -2;
    static final byte COMPILE_OBJECT = 17;
    static final byte RECURSE = 18;
    static final byte DOES_GT = 19;
    static final byte DOT = 20;
    static final byte DOT_DOT = 21;
    static final byte DOT_X = 22;
    static final byte DOT_DOT_X = 23;
    static final byte DOT_O = 24;
    static final byte DOT_DOT_O = 25;
    static final byte DOT_B = 26;
    static final byte DOT_DOT_B = 27;
    static final byte QUESTION = 28;
    static final byte QUESTION_QUESTION = 29;
    static final byte QUESTION_X = 30;
    static final byte QUESTION_QUESTION_X = 31;
    static final byte QUESTION_O = 32;
    static final byte QUESTION_QUESTION_O = 33;
    static final byte QUESTION_B = 34;
    static final byte QUESTION_QUESTION_B = 35;
    static final byte DOT_R = 36;
    static final byte BYE = 37;
    static final byte CLOCK = 38;
    static final byte CR = 39;
    static final byte EMIT = 40;
    static final byte BACKSLASH = 41;
    static final byte SEE = 42;
    static final byte EVALUATE = 43;
    static final byte INCLUDE = 44;
    static final byte LEFT_PAREN = 45;
    static final byte ADD_PREFIX = 46;
    static final byte REMOVE_PREFIX = 47;
    static final byte REFLECT = 48;
    static final byte MOVE = 49;
    static final byte PUSH_FIJI_INTERPRETER = 50;
    static final byte HERE = 51;
    static final byte NULL = 52;
    static final byte TO_BYTEX = 53;
    static final byte TO_OBJECTX = 54;
    static final byte BYTEX_STORE = 55;
    static final byte OBJECTX_STORE = 56;
    static final byte TO_SERIALNUMBER = 57;
    static final byte BRACKET_TICK = 58;
    static final byte MOST_RECENT_WORD = 59;
    static final byte DICTIONARY_NEW = 60;
    static final byte DICTIONARY_FETCH = 61;
    static final byte DICTIONARY_STORE = 62;
    static final byte INTERNAL_LOCAL = 63;
    static final byte LS_PICK = 64;
    static final byte TO_LS = 65;
    static final byte LS_FROM = 66;
    static final byte LS_REPLACE = 67;
    static final byte REPLACE = 68;
    static Hashtable bytehash;
    static String[] byteToString;
    static boolean[] byteImmediate;
    static int[] byteArgumentCount;
    static final boolean debugPrintTrace = false;
    static String padString;
    static int padStringLength;
    StringTokenizer t;
    String pushedString;
    Vector prefixVector;
    FijiPointer handleProgram;

    public boolean bye() {
        return !this.noByeYet;
    }

    static void bytehashAdd(String string, byte by, int n) {
        bytehash.put(string.toLowerCase(), new Byte(by));
        FijiInterpreter.byteToString[by + 128] = string;
        FijiInterpreter.byteArgumentCount[by + 128] = n;
    }

    static void bytehashAdd(String string, byte by) {
        FijiInterpreter.bytehashAdd(string, by, 0);
    }

    static void bytehashAddInteger(int n) {
        Integer n2 = new Integer(n);
        String string = n2.toString();
        byte by = n2.byteValue();
        FijiInterpreter.bytehashAdd(string, by, 0);
    }

    public static boolean getByteCodeImmediate(byte by) {
        if (byteImmediate == null) {
            FijiInterpreter.getByteCode(".");
        }
        return byteImmediate[by + 128];
    }

    public static void setByteCodeImmediate(byte by) {
        FijiInterpreter.byteImmediate[by + 128] = true;
    }

    public static byte getByteCode(String string) {
        Byte by;
        if (bytehash == null) {
            bytehash = new Hashtable();
            byteToString = new String[256];
            byteImmediate = new boolean[256];
            byteArgumentCount = new int[256];
            FijiInterpreter.bytehashAdd("not", (byte)-57, 0);
            FijiInterpreter.bytehashAdd("+", (byte)-77, 0);
            FijiInterpreter.bytehashAdd("-", (byte)-76, 0);
            FijiInterpreter.bytehashAdd("*", (byte)-75, 0);
            FijiInterpreter.bytehashAdd("/", (byte)-74, 0);
            FijiInterpreter.bytehashAdd("%", (byte)-73, 0);
            FijiInterpreter.bytehashAdd("mod", (byte)-73, 0);
            FijiInterpreter.bytehashAdd("<<", (byte)-72, 0);
            FijiInterpreter.bytehashAdd(">>", (byte)-71, 0);
            FijiInterpreter.bytehashAdd(">>>", (byte)-70, 0);
            FijiInterpreter.bytehashAdd("&", (byte)-69, 0);
            FijiInterpreter.bytehashAdd("|", (byte)-68, 0);
            FijiInterpreter.bytehashAdd("^", (byte)-67, 0);
            FijiInterpreter.bytehashAdd("&&", (byte)-66, 0);
            FijiInterpreter.bytehashAdd("||", (byte)-65, 0);
            FijiInterpreter.bytehashAdd("^^", (byte)-64, 0);
            FijiInterpreter.bytehashAdd("<", (byte)-63, 0);
            FijiInterpreter.bytehashAdd("<=", (byte)-62, 0);
            FijiInterpreter.bytehashAdd("=", (byte)-61, 0);
            FijiInterpreter.bytehashAdd("==", (byte)-61, 0);
            FijiInterpreter.bytehashAdd(">=", (byte)-60, 0);
            FijiInterpreter.bytehashAdd(">", (byte)-59, 0);
            FijiInterpreter.bytehashAdd("!=", (byte)-58, 0);
            FijiInterpreter.bytehashAdd("<>", (byte)-58, 0);
            FijiInterpreter.bytehashAdd(".", (byte)20, 0);
            FijiInterpreter.bytehashAdd(".x", (byte)22, 0);
            FijiInterpreter.bytehashAdd(".o", (byte)24, 0);
            FijiInterpreter.bytehashAdd(".b", (byte)26, 0);
            FijiInterpreter.bytehashAdd("..", (byte)21, 0);
            FijiInterpreter.bytehashAdd("..x", (byte)23, 0);
            FijiInterpreter.bytehashAdd("..o", (byte)25, 0);
            FijiInterpreter.bytehashAdd("..b", (byte)27, 0);
            FijiInterpreter.bytehashAdd("?", (byte)28, 0);
            FijiInterpreter.bytehashAdd("?x", (byte)30, 0);
            FijiInterpreter.bytehashAdd("?o", (byte)32, 0);
            FijiInterpreter.bytehashAdd("?b", (byte)34, 0);
            FijiInterpreter.bytehashAdd("??", (byte)29, 0);
            FijiInterpreter.bytehashAdd("??x", (byte)31, 0);
            FijiInterpreter.bytehashAdd("??o", (byte)33, 0);
            FijiInterpreter.bytehashAdd("??b", (byte)35, 0);
            FijiInterpreter.bytehashAdd("here", (byte)51, 0);
            FijiInterpreter.bytehashAdd("null", (byte)52, 0);
            FijiInterpreter.bytehashAdd(".r", (byte)36, 0);
            FijiInterpreter.bytehashAdd("emit", (byte)40, 0);
            FijiInterpreter.bytehashAdd("cr", (byte)39, 0);
            FijiInterpreter.bytehashAdd("\"", (byte)-43, 1);
            FijiInterpreter.byteImmediate[85] = true;
            FijiInterpreter.bytehashAdd(".\"", (byte)-42, 1);
            FijiInterpreter.byteImmediate[86] = true;
            FijiInterpreter.bytehashAdd("\\", (byte)41, 0);
            FijiInterpreter.bytehashAdd("//", (byte)41, 0);
            FijiInterpreter.byteImmediate[169] = true;
            FijiInterpreter.bytehashAdd("(", (byte)45, 0);
            FijiInterpreter.byteImmediate[173] = true;
            FijiInterpreter.bytehashAdd("swap", (byte)-53, 0);
            FijiInterpreter.bytehashAdd("rot", (byte)-52, 0);
            FijiInterpreter.bytehashAdd("dup", (byte)-55, 0);
            FijiInterpreter.bytehashAdd("?dup", (byte)-54, 0);
            FijiInterpreter.bytehashAdd("drop", (byte)-56, 0);
            FijiInterpreter.bytehashAdd("pick", (byte)-48, 0);
            FijiInterpreter.bytehashAdd("replace", (byte)68, 0);
            FijiInterpreter.bytehashAdd("roll", (byte)-49, 0);
            FijiInterpreter.bytehashAdd(">r", (byte)-46, 0);
            FijiInterpreter.bytehashAdd("r>", (byte)-45, 0);
            FijiInterpreter.bytehashAdd("r@", (byte)-44, 0);
            FijiInterpreter.bytehashAdd(":", (byte)-18, 0);
            FijiInterpreter.byteImmediate[110] = true;
            FijiInterpreter.bytehashAdd(":'", (byte)-17, 0);
            FijiInterpreter.byteImmediate[111] = true;
            FijiInterpreter.bytehashAdd(";", (byte)-16, 0);
            FijiInterpreter.byteImmediate[112] = true;
            FijiInterpreter.bytehashAdd("recurse", (byte)18, 1);
            FijiInterpreter.byteImmediate[146] = true;
            FijiInterpreter.bytehashAdd("[", (byte)-12, 0);
            FijiInterpreter.byteImmediate[116] = true;
            FijiInterpreter.bytehashAdd("]", (byte)-11, 0);
            FijiInterpreter.byteImmediate[117] = true;
            FijiInterpreter.bytehashAdd("literal", (byte)-50, 0);
            FijiInterpreter.byteImmediate[78] = true;
            FijiInterpreter.bytehashAdd("push", (byte)-51, 1);
            FijiInterpreter.bytehashAdd("execute", (byte)-110, 0);
            FijiInterpreter.bytehashAdd("'", (byte)-4, 0);
            FijiInterpreter.bytehashAdd("''", (byte)-3, 0);
            FijiInterpreter.bytehashAdd("[']", (byte)58, 0);
            FijiInterpreter.byteImmediate[186] = true;
            FijiInterpreter.bytehashAdd("postpone", (byte)-9, 0);
            FijiInterpreter.byteImmediate[119] = true;
            FijiInterpreter.bytehashAdd("compilebyte", (byte)-2, 0);
            FijiInterpreter.bytehashAdd("compileobject", (byte)17, 1);
            FijiInterpreter.bytehashAdd(">body", (byte)-114, 0);
            FijiInterpreter.bytehashAdd(">cfa", (byte)-113, 0);
            FijiInterpreter.bytehashAdd("body!", (byte)-21, 0);
            FijiInterpreter.bytehashAdd("cfa!", (byte)-20, 0);
            FijiInterpreter.bytehashAdd(">bytex", (byte)53, 0);
            FijiInterpreter.bytehashAdd(">objectx", (byte)54, 0);
            FijiInterpreter.bytehashAdd(">serialnumber", (byte)57, 0);
            FijiInterpreter.bytehashAdd("bytex!", (byte)55, 0);
            FijiInterpreter.bytehashAdd("objectx!", (byte)56, 0);
            FijiInterpreter.bytehashAdd("@", (byte)-31, 0);
            FijiInterpreter.bytehashAdd("!", (byte)-29, 0);
            FijiInterpreter.bytehashAdd("nexttoken", (byte)-41, 0);
            FijiInterpreter.bytehashAdd("nextnonwhitetoken", (byte)-40, 0);
            FijiInterpreter.bytehashAdd("moretokens", (byte)-39, 0);
            FijiInterpreter.bytehashAdd("putbacktoken", (byte)-38, 0);
            FijiInterpreter.bytehashAdd("stricmp", (byte)-37, 0);
            FijiInterpreter.bytehashAdd("strtok", (byte)-36, 0);
            FijiInterpreter.bytehashAdd("substr", (byte)-35, 0);
            FijiInterpreter.bytehashAdd("popchar", (byte)-34, 0);
            FijiInterpreter.bytehashAdd("state?", (byte)-10, 0);
            FijiInterpreter.bytehashAdd("create", (byte)-15, 0);
            FijiInterpreter.bytehashAdd("create'", (byte)-14, 0);
            FijiInterpreter.bytehashAdd("does>", (byte)19, 0);
            FijiInterpreter.byteImmediate[147] = true;
            FijiInterpreter.bytehashAdd(";;", (byte)-13, 0);
            FijiInterpreter.bytehashAdd("finalize", (byte)-13, 0);
            FijiInterpreter.bytehashAdd("immediate", (byte)-6, 0);
            FijiInterpreter.bytehashAdd("inline", (byte)-5, 0);
            FijiInterpreter.bytehashAdd(",", (byte)-32, 0);
            FijiInterpreter.bytehashAdd("c,", (byte)-27, 0);
            FijiInterpreter.bytehashAdd("allot", (byte)-33, 0);
            FijiInterpreter.bytehashAdd("callot", (byte)-28, 0);
            FijiInterpreter.bytehashAdd("addprefix", (byte)46, 0);
            FijiInterpreter.bytehashAdd("removeprefix", (byte)47, 0);
            FijiInterpreter.bytehashAdd("bye", (byte)37, 0);
            FijiInterpreter.bytehashAdd("c+", (byte)-23, 0);
            FijiInterpreter.bytehashAdd("c-", (byte)-22, 0);
            FijiInterpreter.bytehashAdd(">length", (byte)-30, 0);
            FijiInterpreter.bytehashAdd("c>length", (byte)-25, 0);
            FijiInterpreter.bytehashAdd(">class", (byte)-115, 0);
            FijiInterpreter.bytehashAdd("(call)", (byte)-112, 1);
            FijiInterpreter.bytehashAdd("exit", (byte)-111, 0);
            FijiInterpreter.bytehashAdd("(stop)", (byte)-109, 0);
            FijiInterpreter.bytehashAdd("(jump)", (byte)-108, 2);
            FijiInterpreter.bytehashAdd("(jump-check)", (byte)-107, 2);
            FijiInterpreter.bytehashAdd("(branch0)", (byte)-106, 2);
            FijiInterpreter.bytehashAdd("(branch0-check)", (byte)-105, 2);
            FijiInterpreter.bytehashAdd("(jump-forward-push)", (byte)-103, 0);
            FijiInterpreter.bytehashAdd("(jump-backward-push)", (byte)-104, 0);
            FijiInterpreter.bytehashAdd("(jump-forward-fixup)", (byte)-101, 0);
            FijiInterpreter.bytehashAdd("(jump-backward-fixup)", (byte)-102, 0);
            FijiInterpreter.bytehashAdd("(does-set-cfa)", (byte)-19, 1);
            FijiInterpreter.bytehashAdd("(handle-postponed-word)", (byte)-8, 1);
            FijiInterpreter.bytehashAdd("(handle-postponed-bytecode)", (byte)-7, 0);
            FijiInterpreter.bytehashAdd("cs-roll", (byte)-100, 0);
            FijiInterpreter.bytehashAdd("cs-pick", (byte)-99, 0);
            FijiInterpreter.bytehashAdd("do", (byte)-96, 0);
            FijiInterpreter.byteImmediate[32] = true;
            FijiInterpreter.bytehashAdd("?do", (byte)-95, 0);
            FijiInterpreter.byteImmediate[33] = true;
            FijiInterpreter.bytehashAdd("loop", (byte)-88, 0);
            FijiInterpreter.byteImmediate[40] = true;
            FijiInterpreter.bytehashAdd("+loop", (byte)-85, 0);
            FijiInterpreter.byteImmediate[43] = true;
            FijiInterpreter.bytehashAdd("leave", (byte)-91, 0);
            FijiInterpreter.byteImmediate[37] = true;
            FijiInterpreter.bytehashAdd("i", (byte)-94, 0);
            FijiInterpreter.bytehashAdd("j", (byte)-93, 0);
            FijiInterpreter.bytehashAdd("k", (byte)-92, 0);
            FijiInterpreter.bytehashAdd("(do)", (byte)-81, 2);
            FijiInterpreter.bytehashAdd("(?do)", (byte)-79, 2);
            FijiInterpreter.bytehashAdd("(do-check)", (byte)-80, 2);
            FijiInterpreter.bytehashAdd("(?do-check)", (byte)-78, 2);
            FijiInterpreter.bytehashAdd("(loop)", (byte)-87, 2);
            FijiInterpreter.bytehashAdd("(+loop)", (byte)-84, 2);
            FijiInterpreter.bytehashAdd("(leave)", (byte)-90, 2);
            FijiInterpreter.bytehashAdd("(loop-check)", (byte)-86, 2);
            FijiInterpreter.bytehashAdd("(+loop-check)", (byte)-83, 2);
            FijiInterpreter.bytehashAdd("(leave-check)", (byte)-89, 2);
            FijiInterpreter.bytehashAdd("(prep-do)", (byte)-82, 0);
            FijiInterpreter.bytehashAdd("push-fiji-interpreter", (byte)50, 0);
            FijiInterpreter.bytehashAdd("most-recent-word", (byte)59, 0);
            FijiInterpreter.bytehashAdd("dictionary-new", (byte)60, 0);
            FijiInterpreter.bytehashAdd("dictionary-store", (byte)62, 0);
            FijiInterpreter.bytehashAdd("dictionary-fetch", (byte)61, 0);
            FijiInterpreter.bytehashAdd("(local)", (byte)63, 0);
            FijiInterpreter.bytehashAdd("ls-pick", (byte)64, 0);
            FijiInterpreter.bytehashAdd("ls-replace", (byte)67, 0);
            FijiInterpreter.bytehashAdd(">ls", (byte)65, 0);
            FijiInterpreter.bytehashAdd("ls>", (byte)66, 0);
            FijiInterpreter.bytehashAdd("reflect", (byte)48, 0);
            FijiInterpreter.bytehashAdd("see", (byte)42, 0);
            FijiInterpreter.byteImmediate[170] = true;
            FijiInterpreter.bytehashAdd("depth", (byte)-47, 0);
            FijiInterpreter.bytehashAdd("include", (byte)44, 0);
            FijiInterpreter.bytehashAdd("evaluate", (byte)43, 0);
            FijiInterpreter.bytehashAdd("clock", (byte)38, 0);
            FijiInterpreter.bytehashAdd("move", (byte)49, 0);
            FijiInterpreter.bytehashAddInteger(-1);
            FijiInterpreter.bytehashAddInteger(0);
            FijiInterpreter.bytehashAddInteger(1);
            FijiInterpreter.bytehashAddInteger(2);
            FijiInterpreter.bytehashAddInteger(3);
            FijiInterpreter.bytehashAddInteger(4);
            FijiInterpreter.bytehashAddInteger(5);
            FijiInterpreter.bytehashAddInteger(6);
            FijiInterpreter.bytehashAddInteger(7);
            FijiInterpreter.bytehashAddInteger(8);
            FijiInterpreter.bytehashAddInteger(9);
            FijiInterpreter.bytehashAddInteger(10);
            FijiInterpreter.bytehashAddInteger(11);
            FijiInterpreter.bytehashAddInteger(12);
            FijiInterpreter.bytehashAddInteger(13);
            FijiInterpreter.bytehashAddInteger(14);
            FijiInterpreter.bytehashAddInteger(15);
            FijiInterpreter.bytehashAddInteger(16);
            FijiInterpreter.bytehashAdd(">string", (byte)-126, 0);
            FijiInterpreter.bytehashAdd(">double", (byte)-123, 0);
            FijiInterpreter.bytehashAdd(">float", (byte)-122, 0);
            FijiInterpreter.bytehashAdd(">long", (byte)-121, 0);
            FijiInterpreter.bytehashAdd(">int", (byte)-120, 0);
            FijiInterpreter.bytehashAdd(">integer", (byte)-120, 0);
            FijiInterpreter.bytehashAdd(">short", (byte)-119, 0);
            FijiInterpreter.bytehashAdd(">byte", (byte)-118, 0);
            FijiInterpreter.bytehashAdd(">char", (byte)-117, 0);
            FijiInterpreter.bytehashAdd(">character", (byte)-117, 0);
            FijiInterpreter.bytehashAdd(">boolean", (byte)-116, 0);
        }
        if ((by = (Byte)bytehash.get(string.toLowerCase())) == null) {
            return -127;
        }
        return by;
    }

    static void print(String string) {
        System.out.print(string);
    }

    static void print(char c) {
        System.out.print(c);
    }

    static void println(String string) {
        System.out.println(string);
    }

    static void println() {
        System.out.println("");
    }

    void init() {
        this.dictionary = new FijiDictionary();
        this.bytes = new Vector();
        this.objects = new Vector();
        if (globalDictionary == null) {
            globalDictionary = this.dictionary;
            this.interpret(" : >pfa >body ; inline  : :noname \"\" create' postpone ] most-recent-word ; immediate  : true 1 ; inline  : false 0 ; inline  : constant create , does> @ ; immediate  : variable create 0 , ; immediate  : cells ; immediate  : 0?  0 =  ; inline  : 0=  0 =  ; inline  : 1+  1 +  ; inline  : 1-  1 -  ; inline  : +!  dup @ 1 + !  ; inline  : over  1 pick  ; inline  : tuck  dup rot rot  ; inline  : 2dup  over over  ; inline  : 2drop  drop drop  ; inline  : doublequote  34C  ; inline  : sp  32C  ; inline  \"java.lang.String\" constant java.lang.String  \"java.lang.Double\" constant java.lang.Double  \"java.lang.Float\" constant java.lang.Float  \"java.lang.Long\" constant java.lang.Long  \"java.lang.Integer\" constant java.lang.Integer  \"java.lang.Character\" constant java.lang.Character  \"java.lang.Short\" constant java.lang.Short  \"java.lang.Byte\" constant java.lang.Byte  \"java.lang.Void\" constant java.lang.Void  : if  postpone (branch0-check) (jump-forward-push) ; immediate  : then  (jump-forward-fixup) ; immediate  : endif  postpone then ; immediate  : begin (jump-backward-push) ; immediate  : again  postpone (jump-check) (jump-backward-fixup) ; immediate  : until  postpone (branch0-check) (jump-backward-fixup) ; immediate  : ahead postpone (jump-check) (jump-forward-push) ; immediate  : while postpone if 1 cs-roll ; immediate  : repeat postpone again postpone then ; immediate  : else  postpone ahead 1 cs-roll postpone then ; immediate  : case 0 ; immediate  : of 1 + postpone over postpone = postpone if postpone drop ; immediate  : endof postpone else ; immediate  : endcase postpone drop 0? do postpone then loop ; immediate  : dumpword postpone see ; immediate  : quit .\"It's not 'quit', it's 'bye'.  Remember that next time, huh?\" bye ;  : value postpone constant ; immediate  : to  \t\t' \t\tstate? \t\tif \t\t\tdup \t\t\tpostpone literal postpone >body  \t\t\t>cfa >serialnumber \"(do-local)\" '' >cfa >serialnumber = \t\t\tif \t\t\t\tpostpone @ postpone ls-replace \t\t\telse \t\t\t\tpostpone ! \t\t\tendif \t\telse \t\t\t>body ! \t\tthen \t\t; immediate  : [else]  ( -- )      1 begin                                      begin          nextnonwhitetoken dup                                            >length            while          dup \"[if]\" stricmp 0=          if                                           drop 1+                                  else                                         dup  \"[else]\" stricmp 0=                 if                                            drop 1- dup if 1+ then                  else                                         dup \"[endif]\" stricmp 0=                 swap \"[then]\" stricmp 0=                 || if                                        1-                                       then            then          then ?dup 0=  if exit then               repeat  drop                             moretokens 0= until                        drop  ;  immediate  : [if]  ( flag -- )  0= if postpone [else] then ;  immediate  : [then]   ( -- )  ;  immediate  : [endif]  ( -- )  ;  immediate  : .s  ( -- )  .\"[| .s begin ] depth \" depth .. cr   depth 0 > if       1 depth 1- do           .\" | \" i 4 .r .\": \"           i 1- pick           dup \t\t     .\"class \" >class . .\" \"           .\"== \" .           cr           -1       +loop   endif  .\"[| .s end ]\" cr  ; : nothing ;  : doer postpone : postpone ; ;  variable (make-marker)  : (make-reset-marker) (make-marker) (make-marker) ! ;  (make-reset-marker)  : (make)  \tr> dup 1+ 1 c+ dup 1+ 1 c+ swap @ body!  \tdup @ ?dup  \tif  \t\tdup\t\t\t \t\t>bytex\t\t \t\trot\t\t\t \t\tswap\t\t \t\tbytex!\t\t \t\tswap\t\t \t\t>objectx\t \t\tobjectx!\t \t\t>r  \telse  \t\tdrop  \tthen  \t;  : make  \tstate?  \tif  \t\tpostpone (make)  \t\t(make-marker) @ >serialnumber  \t\there >serialnumber  \t\t!=  \t\tif  \t\t\there (make-marker) !  \t\tendif  \t\tpostpone push 0 ,  \telse  \t\t' (make-marker) !  \t\t\"\" create' postpone ]  \tthen  \t; immediate  : ;and  \tpostpone exit here (make-marker) @ !  \t; immediate  : ;make  \tpostpone ;  \tmost-recent-word >body (make-marker) @ body!  \t(make-reset-marker)  \t; immediate  : (do-local) @ ls-pick ;  : locals|   \tbegin  \tnextnonwhitetoken dup \"|\" !=  \twhile  \t1 (local)  \trepeat \t\tdrop  \t; immediate  : local  \tnextnonwhitetoken dup >length (local)  \t;  immediate  : end-locals  \t0 0 (local) ;  immediate  1 value {no-comment-yet}  : {  \t0 >ls  \t1 to {no-comment-yet}  \tbegin  \t\tnextnonwhitetoken  \t\tdup  \t\t\"}\" !=  \twhile  \t\tdup  \t\t\"--\" =  \t\tif  \t\t\tdrop  \t\t\t0 to {no-comment-yet}  \t\telse  \t\t\t{no-comment-yet}  \t\t\tif  \t\t\t\tls>  \t\t\t\tswap  \t\t\t\t>ls  \t\t\t\t1+  \t\t\t\t>ls  \t\t\telse  \t\t\t\tdrop  \t\t\tendif  \t\tendif  \trepeat  \tdrop  \tls> 0  \tdo  \t\tls> 1 (local)  \tloop  \t; immediate  : } ; immediate  : for postpone 0 postpone swap postpone ?do ; immediate  : next postpone -1 postpone +loop ; immediate ");
            this.dictionary = new FijiDictionary();
            FijiWord fijiWord = globalDictionary.lookup("(do-local)");
            doLocal = doDoes.copy();
            FijiInterpreter.doLocal.bytes = fijiWord.PFA.bytes;
            FijiInterpreter.doLocal.objects = fijiWord.PFA.objects;
            FijiInterpreter.doLocal.serialNumber = fijiWord.CFA.serialNumber;
        }
    }

    public FijiInterpreter() {
        byte[] byArray = new byte[2];
        byArray[1] = -109;
        this.handleProgram = new FijiPointer(byArray, new Object[1]);
        this.init();
    }

    Object popReturn() {
        Object e = this.RS.lastElement();
        this.RS.removeElementAt(this.RS.size() - 1);
        return e;
    }

    void pushReturn(Object object) {
        this.RS.addElement(object);
    }

    Object pickReturn(int n) {
        return this.RS.elementAt(this.RS.size() - 1 - n);
    }

    void replaceReturn(int n, Object object) {
        this.RS.setElementAt(object, this.RS.size() - 1 - n);
    }

    Object popControl() {
        Object e = this.CS.lastElement();
        this.CS.removeElementAt(this.CS.size() - 1);
        return e;
    }

    void pushControl(Object object) {
        this.CS.addElement(object);
    }

    Object pickControl(int n) {
        return this.CS.elementAt(this.CS.size() - 1 - n);
    }

    void replaceControl(int n, Object object) {
        this.CS.setElementAt(object, this.CS.size() - 1 - n);
    }

    Object popLocal() {
        Object e = this.LS.lastElement();
        this.LS.removeElementAt(this.LS.size() - 1);
        return e;
    }

    void pushLocal(Object object) {
        this.LS.addElement(object);
    }

    Object pickLocal(int n) {
        return this.LS.elementAt(this.LS.size() - 1 - n);
    }

    void replaceLocal(int n, Object object) {
        this.LS.setElementAt(object, this.LS.size() - 1 - n);
    }

    Object tos() {
        return this.DS.lastElement();
    }

    Object pick(int n) {
        return this.DS.elementAt(this.DS.size() - 1 - n);
    }

    Object pop() {
        Object e = this.DS.lastElement();
        this.DS.removeElementAt(this.DS.size() - 1);
        return e;
    }

    void replace(int n, Object object) {
        this.DS.setElementAt(object, this.DS.size() - 1 - n);
    }

    void push(Object object) {
        this.DS.addElement(object);
    }

    void push(double d) {
        this.push(new Double(d));
    }

    void push(float f) {
        this.push(new Float(f));
    }

    void push(long l) {
        this.push(new Long(l));
    }

    void push(int n) {
        this.push(new Integer(n));
    }

    void push(short s) {
        this.push(new Short(s));
    }

    void push(byte by) {
        this.push(new Byte(by));
    }

    void push(char c) {
        this.push(new Character(c));
    }

    void push(boolean bl) {
        this.push(new Boolean(bl));
    }

    FijiWord lookup(String string) {
        FijiWord fijiWord = null;
        if (this.newWord != null) {
            if (this.doesProgram != null && this.doesProgram.locals != null && (fijiWord = this.doesProgram.locals.lookup(string)) != null) {
                return fijiWord;
            }
            if (this.newWord.PFA.locals != null && (fijiWord = this.newWord.PFA.locals.lookup(string)) != null) {
                return fijiWord;
            }
        }
        if ((fijiWord = this.dictionary.lookup(string)) != null) {
            return fijiWord;
        }
        fijiWord = globalDictionary.lookup(string);
        if (fijiWord != null) {
            return fijiWord;
        }
        return null;
    }

    static int DetermineType(Object object) {
        if (object instanceof String) {
            return -126;
        }
        if (object instanceof Double) {
            return -123;
        }
        if (object instanceof Float) {
            return -122;
        }
        if (object instanceof Long) {
            return -121;
        }
        if (object instanceof Integer) {
            return -120;
        }
        if (object instanceof Short) {
            return -119;
        }
        if (object instanceof Byte) {
            return -118;
        }
        if (object instanceof Character) {
            return -117;
        }
        if (object instanceof Boolean) {
            return -116;
        }
        if (object instanceof FijiPointer) {
            return -125;
        }
        return -127;
    }

    static int DetermineTypePromotion(Object object, Object object2) {
        int n;
        int n2 = FijiInterpreter.DetermineType(object);
        if (n2 < (n = FijiInterpreter.DetermineType(object2))) {
            return n2;
        }
        return n;
    }

    Object MathString(byte by, String string, String string2) {
        boolean bl;
        if (by == -77) {
            return String.valueOf(string) + string2;
        }
        int n = string.compareTo(string2);
        switch (by) {
            case -63: {
                bl = n < 0;
                break;
            }
            case -62: {
                bl = n <= 0;
                break;
            }
            case -61: {
                bl = n == 0;
                break;
            }
            case -60: {
                bl = n >= 0;
                break;
            }
            case -59: {
                bl = n > 0;
                break;
            }
            case -58: {
                bl = n != 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        return new Integer(bl ? 1 : 0);
    }

    Object MathPointer(byte by, FijiPointer fijiPointer, Object object) {
        FijiPointer fijiPointer2 = fijiPointer;
        switch (by) {
            case -77: {
                fijiPointer2.objectX += ((Integer)object).intValue();
                break;
            }
            case -76: {
                fijiPointer2.objectX -= ((Integer)object).intValue();
                break;
            }
            case -61: {
                return new Integer(fijiPointer.serialNumber == ((FijiPointer)object).serialNumber ? 1 : 0);
            }
            case -58: {
                return new Integer(fijiPointer.serialNumber != ((FijiPointer)object).serialNumber ? 1 : 0);
            }
        }
        return fijiPointer2;
    }

    Object MathDouble(byte by, double d, double d2) {
        double d3 = 0.0;
        switch (by) {
            case -57: {
                d3 = d == 0.0 ? 1 : 0;
                break;
            }
            case -77: {
                d3 = d + d2;
                break;
            }
            case -76: {
                d3 = d - d2;
                break;
            }
            case -75: {
                d3 = d * d2;
                break;
            }
            case -74: {
                d3 = d / d2;
                break;
            }
            case -63: {
                d3 = d < d2 ? 1.0 : 0.0;
                break;
            }
            case -62: {
                d3 = d <= d2 ? 1.0 : 0.0;
                break;
            }
            case -61: {
                d3 = d == d2 ? 1.0 : 0.0;
                break;
            }
            case -60: {
                d3 = d >= d2 ? 1.0 : 0.0;
                break;
            }
            case -59: {
                d3 = d > d2 ? 1.0 : 0.0;
                break;
            }
            case -58: {
                d3 = d != d2 ? 1.0 : 0.0;
            }
        }
        return new Double(d3);
    }

    Object MathFloat(byte by, float f, float f2) {
        float f3 = 0.0f;
        switch (by) {
            case -57: {
                f3 = f == 0.0f ? 1 : 0;
                break;
            }
            case -77: {
                f3 = f + f2;
                break;
            }
            case -76: {
                f3 = f - f2;
                break;
            }
            case -75: {
                f3 = f * f2;
                break;
            }
            case -74: {
                f3 = f / f2;
                break;
            }
            case -63: {
                f3 = f < f2 ? 1.0f : 0.0f;
                break;
            }
            case -62: {
                f3 = f <= f2 ? 1.0f : 0.0f;
                break;
            }
            case -61: {
                f3 = f == f2 ? 1.0f : 0.0f;
                break;
            }
            case -60: {
                f3 = f >= f2 ? 1.0f : 0.0f;
                break;
            }
            case -59: {
                f3 = f > f2 ? 1.0f : 0.0f;
                break;
            }
            case -58: {
                f3 = f != f2 ? 1.0f : 0.0f;
            }
        }
        return new Float(f3);
    }

    Object MathLong(byte by, long l, long l2) {
        long l3 = 0L;
        switch (by) {
            case -57: {
                l3 = l != 0L ? 0 : 1;
                break;
            }
            case -77: {
                l3 = l + l2;
                break;
            }
            case -76: {
                l3 = l - l2;
                break;
            }
            case -75: {
                l3 = l * l2;
                break;
            }
            case -74: {
                l3 = l / l2;
                break;
            }
            case -72: {
                l3 = l << (int)l2;
                break;
            }
            case -71: {
                l3 = l >> (int)l2;
                break;
            }
            case -70: {
                l3 = l >>> (int)l2;
                break;
            }
            case -69: {
                l3 = l & l2;
                break;
            }
            case -68: {
                l3 = l | l2;
                break;
            }
            case -67: {
                l3 = l ^ l2;
                break;
            }
            case -66: {
                l3 = l != 0L && l2 != 0L ? 1 : 0;
                break;
            }
            case -65: {
                l3 = l != 0L || l2 != 0L ? 1 : 0;
                break;
            }
            case -64: {
                l3 = (l != 0L ? 1 : 0) ^ (l2 != 0L ? 1 : 0);
                break;
            }
            case -63: {
                l3 = l < l2 ? 1 : 0;
                break;
            }
            case -62: {
                l3 = l <= l2 ? 1 : 0;
                break;
            }
            case -61: {
                l3 = l == l2 ? 1 : 0;
                break;
            }
            case -60: {
                l3 = l >= l2 ? 1 : 0;
                break;
            }
            case -59: {
                l3 = l > l2 ? 1 : 0;
                break;
            }
            case -58: {
                l3 = l != l2 ? 1 : 0;
            }
        }
        return new Long(l3);
    }

    Object MathInteger(byte by, int n, int n2) {
        int n3 = 0;
        switch (by) {
            case -57: {
                n3 = n != 0 ? 0 : 1;
                break;
            }
            case -77: {
                n3 = n + n2;
                break;
            }
            case -76: {
                n3 = n - n2;
                break;
            }
            case -75: {
                n3 = n * n2;
                break;
            }
            case -74: {
                n3 = n / n2;
                break;
            }
            case -72: {
                n3 = n << n2;
                break;
            }
            case -71: {
                n3 = n >> n2;
                break;
            }
            case -70: {
                n3 = n >>> n2;
                break;
            }
            case -69: {
                n3 = n & n2;
                break;
            }
            case -68: {
                n3 = n | n2;
                break;
            }
            case -67: {
                n3 = n ^ n2;
                break;
            }
            case -66: {
                n3 = n != 0 && n2 != 0 ? 1 : 0;
                break;
            }
            case -65: {
                n3 = n != 0 || n2 != 0 ? 1 : 0;
                break;
            }
            case -64: {
                n3 = (n != 0 ? 1 : 0) ^ (n2 != 0 ? 1 : 0);
                break;
            }
            case -63: {
                n3 = n < n2 ? 1 : 0;
                break;
            }
            case -62: {
                n3 = n <= n2 ? 1 : 0;
                break;
            }
            case -61: {
                n3 = n == n2 ? 1 : 0;
                break;
            }
            case -60: {
                n3 = n >= n2 ? 1 : 0;
                break;
            }
            case -59: {
                n3 = n > n2 ? 1 : 0;
                break;
            }
            case -58: {
                n3 = n != n2 ? 1 : 0;
            }
        }
        return new Integer(n3);
    }

    Object MathShort(byte by, short s, short s2) {
        int n = 0;
        switch (by) {
            case -57: {
                n = s != 0 ? 0 : 1;
                break;
            }
            case -77: {
                n = s + s2;
                break;
            }
            case -76: {
                n = s - s2;
                break;
            }
            case -75: {
                n = s * s2;
                break;
            }
            case -74: {
                n = s / s2;
                break;
            }
            case -72: {
                n = s << s2;
                break;
            }
            case -71: {
                n = s >> s2;
                break;
            }
            case -70: {
                n = s >>> s2;
                break;
            }
            case -69: {
                n = s & s2;
                break;
            }
            case -68: {
                n = s | s2;
                break;
            }
            case -67: {
                n = s ^ s2;
                break;
            }
            case -66: {
                n = s != 0 && s2 != 0 ? 1 : 0;
                break;
            }
            case -65: {
                n = s != 0 || s2 != 0 ? 1 : 0;
                break;
            }
            case -64: {
                n = (s != 0 ? 1 : 0) ^ (s2 != 0 ? 1 : 0);
                break;
            }
            case -63: {
                n = s < s2 ? 1 : 0;
                break;
            }
            case -62: {
                n = s <= s2 ? 1 : 0;
                break;
            }
            case -61: {
                n = s == s2 ? 1 : 0;
                break;
            }
            case -60: {
                n = s >= s2 ? 1 : 0;
                break;
            }
            case -59: {
                n = s > s2 ? 1 : 0;
                break;
            }
            case -58: {
                n = s != s2 ? 1 : 0;
            }
        }
        return new Integer(n);
    }

    Object MathByte(byte by, byte by2, byte by3) {
        int n = 0;
        switch (by) {
            case -57: {
                n = by2 != 0 ? 0 : 1;
                break;
            }
            case -77: {
                n = by2 + by3;
                break;
            }
            case -76: {
                n = by2 - by3;
                break;
            }
            case -75: {
                n = by2 * by3;
                break;
            }
            case -74: {
                n = by2 / by3;
                break;
            }
            case -72: {
                n = by2 << by3;
                break;
            }
            case -71: {
                n = by2 >> by3;
                break;
            }
            case -70: {
                n = by2 >>> by3;
                break;
            }
            case -69: {
                n = by2 & by3;
                break;
            }
            case -68: {
                n = by2 | by3;
                break;
            }
            case -67: {
                n = by2 ^ by3;
                break;
            }
            case -66: {
                n = by2 != 0 && by3 != 0 ? 1 : 0;
                break;
            }
            case -65: {
                n = by2 != 0 || by3 != 0 ? 1 : 0;
                break;
            }
            case -64: {
                n = (by2 != 0 ? 1 : 0) ^ (by3 != 0 ? 1 : 0);
                break;
            }
            case -63: {
                n = by2 < by3 ? 1 : 0;
                break;
            }
            case -62: {
                n = by2 <= by3 ? 1 : 0;
                break;
            }
            case -61: {
                n = by2 == by3 ? 1 : 0;
                break;
            }
            case -60: {
                n = by2 >= by3 ? 1 : 0;
                break;
            }
            case -59: {
                n = by2 > by3 ? 1 : 0;
                break;
            }
            case -58: {
                n = by2 != by3 ? 1 : 0;
            }
        }
        return new Short((short)n);
    }

    Object MathCharacter(byte by, char c, char c2) {
        boolean bl = false;
        switch (by) {
            case -77: {
                return new Character((char)(c + c2));
            }
            case -76: {
                return new Character((char)(c - c2));
            }
            case -75: 
            case -74: 
            case -72: 
            case -71: 
            case -70: 
            case -69: 
            case -68: 
            case -67: 
            case -66: 
            case -65: 
            case -64: {
                bl = false;
                break;
            }
            case -63: {
                bl = c < c2;
                break;
            }
            case -62: {
                bl = c <= c2;
                break;
            }
            case -61: {
                bl = c == c2;
                break;
            }
            case -60: {
                bl = c >= c2;
                break;
            }
            case -59: {
                bl = c > c2;
                break;
            }
            case -58: {
                bl = c != c2;
            }
        }
        return new Integer((short)(bl ? 1 : 0));
    }

    void optimizeJump(int n, int n2) {
        int n3 = ((Number)this.program.objects[n2]).intValue();
        int n4 = ((Number)this.program.objects[n2 + 1]).intValue();
        switch (this.program.bytes[n3]) {
            case -107: {
                this.optimizeJump(n3, n4);
            }
            case -108: {
                this.program.objects[n2] = this.program.objects[n4];
                this.program.objects[n2 + 1] = this.program.objects[n4 + 1];
            }
        }
        int n5 = n;
        this.program.bytes[n5] = (byte)(this.program.bytes[n5] - 1);
    }

    void finalizeEntry() {
        if (this.creating) {
            this.creating = false;
            this.compiling = false;
            this.bytes.addElement(new Byte(-111));
            byte[] byArray = new byte[this.bytes.size()];
            int n = 0;
            while (n < this.bytes.size()) {
                byArray[n] = (Byte)this.bytes.elementAt(n);
                ++n;
            }
            this.bytes.removeAllElements();
            Object[] objectArray = new Object[this.objects.size()];
            this.objects.copyInto(objectArray);
            this.objects.removeAllElements();
            this.newWord.PFA.bytes = byArray;
            this.newWord.PFA.objects = objectArray;
            if (this.doesProgram != null) {
                this.doesProgram.bytes = byArray;
                this.doesProgram.objects = objectArray;
                this.doesProgram = null;
            }
        }
    }

    FijiPointer ensureFinal(FijiPointer fijiPointer) {
        if (!this.creating || this.newWord.PFA.serialNumber != fijiPointer.serialNumber) {
            return fijiPointer;
        }
        this.finalizeEntry();
        return this.newWord.PFA;
    }

    void pushFixup(byte by) {
        FijiCallFrame fijiCallFrame = new FijiCallFrame(this.program.copy());
        fijiCallFrame.byteX = this.bytes.size();
        fijiCallFrame.objectX = this.objects.size();
        fijiCallFrame.operand = by;
        this.pushControl(fijiCallFrame);
        if (by >= -103) {
            this.objects.addElement(null);
            this.objects.addElement(null);
        }
    }

    void jump() {
        this.program.byteX = ((Number)this.program.objects[this.program.objectX++]).intValue();
        this.program.objectX = ((Number)this.program.objects[this.program.objectX]).intValue();
    }

    void skipJump() {
        this.program.objectX += 2;
    }

    void fixupForward(FijiCallFrame fijiCallFrame) {
        this.objects.setElementAt(new Integer(this.bytes.size()), fijiCallFrame.objectX);
        this.objects.setElementAt(new Integer(this.objects.size()), fijiCallFrame.objectX + 1);
    }

    void fixupBackward(FijiCallFrame fijiCallFrame) {
        this.objects.addElement(new Integer(fijiCallFrame.byteX));
        this.objects.addElement(new Integer(fijiCallFrame.objectX));
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void interpret(FijiPointer var1_1) {
        if (!this.noByeYet) {
            return;
        }
        this.program = var1_1;
        var18_2 = true;
        block166: while (var18_2) {
            block167: while (true) {
                var15_16 = this.program.bytes[this.program.byteX++];
                cfr_temp_0 = -2147483648;
                block168: do {
                    block0 : switch (cfr_temp_0 == -2147483648 ? var15_16 : cfr_temp_0) {
                        case -1: 
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: {
                            this.push(var15_16);
                            break;
                        }
                        case -57: {
                            switch (FijiInterpreter.DetermineType(this.tos())) {
                                case -123: {
                                    this.replace(0, this.MathDouble((byte)var15_16, ((Number)this.tos()).doubleValue(), 0.0));
                                    break block0;
                                }
                                case -122: {
                                    this.replace(0, this.MathFloat((byte)var15_16, ((Number)this.tos()).floatValue(), 0.0f));
                                    break block0;
                                }
                                case -121: {
                                    this.replace(0, this.MathLong((byte)var15_16, ((Number)this.tos()).longValue(), 0L));
                                    break block0;
                                }
                                case -120: {
                                    this.replace(0, this.MathInteger((byte)var15_16, ((Number)this.tos()).intValue(), 0));
                                    break block0;
                                }
                                case -119: {
                                    this.replace(0, this.MathShort((byte)var15_16, ((Number)this.tos()).shortValue(), (short)0));
                                    break block0;
                                }
                                case -118: {
                                    this.replace(0, this.MathByte((byte)var15_16, ((Number)this.tos()).byteValue(), (byte)0));
                                    break block0;
                                }
                            }
                            System.out.println("unary operation not supported for top two stack elements");
                            break;
                        }
                        case -77: 
                        case -76: 
                        case -75: 
                        case -74: 
                        case -72: 
                        case -71: 
                        case -70: 
                        case -69: 
                        case -68: 
                        case -67: 
                        case -66: 
                        case -65: 
                        case -64: 
                        case -63: 
                        case -62: 
                        case -61: 
                        case -60: 
                        case -59: 
                        case -58: {
                            var19_19 = this.pop();
                            var20_30 = this.pop();
                            var21_31 = FijiInterpreter.DetermineTypePromotion(var20_30, var19_19);
                            var17_18 = false;
                            switch (var21_31) {
                                case -125: {
                                    var17_18 = var19_19 instanceof FijiPointer;
                                    break;
                                }
                                case -126: {
                                    var17_18 = true;
                                    break;
                                }
                            }
                            if (var17_18) {
                                var22_39 = var20_30;
                                var20_30 = var19_19;
                                var19_19 = var22_39;
                            }
                            switch (var21_31) {
                                case -126: {
                                    this.push(this.MathString((byte)var15_16, var20_30.toString(), var19_19.toString()));
                                    break block0;
                                }
                                case -125: {
                                    this.push(this.MathPointer((byte)var15_16, (FijiPointer)var20_30, var19_19));
                                    break block0;
                                }
                                case -123: {
                                    this.push(this.MathDouble((byte)var15_16, ((Number)var20_30).doubleValue(), ((Number)var19_19).doubleValue()));
                                    break block0;
                                }
                                case -122: {
                                    this.push(this.MathFloat((byte)var15_16, ((Number)var20_30).floatValue(), ((Number)var19_19).floatValue()));
                                    break block0;
                                }
                                case -121: {
                                    this.push(this.MathLong((byte)var15_16, ((Number)var20_30).longValue(), ((Number)var19_19).longValue()));
                                    break block0;
                                }
                                case -120: {
                                    this.push(this.MathInteger((byte)var15_16, ((Number)var20_30).intValue(), ((Number)var19_19).intValue()));
                                    break block0;
                                }
                                case -119: {
                                    this.push(this.MathShort((byte)var15_16, ((Number)var20_30).shortValue(), ((Number)var19_19).shortValue()));
                                    break block0;
                                }
                                case -117: {
                                    switch (FijiInterpreter.DetermineType(var19_19)) {
                                        case -117: {
                                            var3_4 = ((Character)var19_19).charValue();
                                            break;
                                        }
                                        default: {
                                            var3_4 = (char)((Number)var19_19).intValue();
                                        }
                                    }
                                    this.push(this.MathCharacter((byte)var15_16, ((Character)var20_30).charValue(), var3_4));
                                    break block0;
                                }
                                case -118: {
                                    this.push(this.MathByte((byte)var15_16, ((Number)var20_30).byteValue(), ((Number)var19_19).byteValue()));
                                    break block0;
                                }
                            }
                            System.out.println("math operand not supported for top two stack elements");
                            break;
                        }
                        case -107: 
                        case -105: {
                            this.optimizeJump(this.program.byteX - 1, this.program.objectX);
                        }
                        case -106: {
                            if (var15_16 != -107) {
                                var8_9 = this.pop();
                                if (var8_9 == null) {
                                    var16_17 = false;
                                } else if (var8_9 instanceof FijiPointer) {
                                    var16_17 = true;
                                } else if (var8_9 instanceof Boolean) {
                                    var16_17 = (Boolean)var8_9;
                                } else {
                                    v0 = var16_17 = ((Number)var8_9).intValue() != 0;
                                }
                                if (var16_17) {
                                    this.skipJump();
                                    break;
                                }
                            }
                        }
                        case -108: {
                            this.jump();
                            break;
                        }
                        case 52: {
                            this.push(null);
                            break;
                        }
                        case 51: {
                            if (!this.creating) {
                                System.out.println("calling here while not creating!  ignoring.");
                                break;
                            }
                            var10_11 = this.newWord.PFA.copy();
                            var10_11.objectX = this.objects.size();
                            var10_11.byteX = this.bytes.size();
                            this.push(var10_11);
                            break;
                        }
                        case -78: {
                            this.optimizeJump(this.program.byteX - 1, this.program.objectX);
                        }
                        case -79: {
                            if (((Number)this.tos()).intValue() != ((Number)this.pick(1)).intValue()) {
                                this.skipJump();
                                break;
                            }
                            this.pop();
                            this.pop();
                            this.jump();
                            break;
                        }
                        case -82: {
                            var5_6 = ((Number)this.pop()).intValue();
                            var7_8 = ((Number)this.pop()).intValue();
                            this.pushReturn(new Integer(var7_8));
                            this.pushReturn(new Integer(var5_6));
                            this.pushReturn(new Integer(var5_6 < var7_8 ? 1 : 0));
                            break;
                        }
                        case -80: {
                            this.optimizeJump(this.program.byteX - 1, this.program.objectX);
                        }
                        case -81: {
                            var7_8 = ((Number)this.pickReturn(2)).intValue();
                            var5_6 = ((Number)this.pickReturn(1)).intValue();
                            var6_7 = ((Number)this.pickReturn(0)).intValue();
                            if (((var5_6 < var7_8 ? 1 : 0) ^ var6_7) != 0) {
                                this.popReturn();
                                this.popReturn();
                                this.popReturn();
                                this.jump();
                                break;
                            }
                            this.skipJump();
                            break;
                        }
                        case -94: 
                        case -93: 
                        case -92: {
                            this.push(this.pickReturn(3 * (var15_16 - -94) + 1));
                            break;
                        }
                        case -89: {
                            this.optimizeJump(this.program.byteX - 1, this.program.objectX);
                        }
                        case -90: {
                            this.popReturn();
                            this.popReturn();
                            this.popReturn();
                            this.jump();
                            break;
                        }
                        case -86: 
                        case -83: {
                            this.optimizeJump(this.program.byteX - 1, this.program.objectX);
                            var15_16 = (byte)(var15_16 - 1);
                        }
                        case -87: 
                        case -84: {
                            var5_6 = var15_16 == -87 ? 1 : ((Number)this.pop()).intValue();
                            this.replaceReturn(1, new Integer(var5_6 += ((Number)this.pickReturn(1)).intValue()));
                            this.jump();
                            break;
                        }
                        case -95: {
                            this.handleLater((byte)-78, null, null);
                            this.pushFixup((byte)-95);
                        }
                        case -96: {
                            this.handleLater((byte)-82, null, null);
                            this.pushFixup((byte)-96);
                            this.handleLater((byte)-80, null, null);
                            if (var15_16 != -95) continue block166;
                            var8_9 = this.popControl();
                            var9_10 = this.popControl();
                            this.pushControl(var8_9);
                            this.pushControl(var9_10);
                            break;
                        }
                        case -88: 
                        case -85: {
                            var8_9 = new Object();
                            this.handleLater((byte)(var15_16 + 2), var8_9, var8_9);
                            block169: while (true) {
                                var4_5 = (FijiCallFrame)this.popControl();
                                switch (var4_5.operand) {
                                    default: {
                                        continue block169;
                                    }
                                    case -95: 
                                    case -91: {
                                        this.fixupForward(var4_5);
                                        continue block169;
                                    }
                                    case -96: 
                                }
                                break;
                            }
                            this.objects.removeElementAt(this.objects.size() - 1);
                            this.objects.removeElementAt(this.objects.size() - 1);
                            this.fixupBackward(var4_5);
                            this.fixupForward(var4_5);
                            break;
                        }
                        case -91: {
                            this.bytes.addElement(new Byte(-89));
                        }
                        case -104: 
                        case -103: {
                            this.pushFixup((byte)var15_16);
                            break;
                        }
                        case -102: 
                        case -101: {
                            var5_6 = 0;
                            while (true) {
                                var4_5 = (FijiCallFrame)this.popControl();
                                if (var4_5.operand != -91) break;
                                ++var5_6;
                                this.push(var4_5);
                            }
                            if (var15_16 == -101) {
                                this.fixupForward(var4_5);
                            } else {
                                this.fixupBackward(var4_5);
                            }
                            while (var5_6 > 0) {
                                var8_9 = this.pop();
                                this.pushControl(var8_9);
                                --var5_6;
                            }
                            continue block166;
                        }
                        case -43: 
                        case -42: {
                            var13_14 = "";
                            while (this.moreTokens()) {
                                var12_13 = this.nextToken();
                                var19_20 = var12_13.indexOf(34);
                                if (var19_20 != -1) {
                                    var13_14 = String.valueOf(var13_14) + var12_13.substring(0, var19_20);
                                    break;
                                }
                                var13_14 = String.valueOf(var13_14) + var12_13;
                            }
                            this.handleObject(var13_14);
                            if (var15_16 != -42) continue block166;
                            this.handleByteCode((byte)21);
                            break;
                        }
                        case -54: {
                            var8_9 = this.tos();
                            if (var8_9 == null || var8_9 instanceof Number && ((Number)var8_9).intValue() == 0) continue block166;
                        }
                        case -55: {
                            var8_9 = this.tos();
                            if (var8_9 instanceof FijiPointer) {
                                this.push(((FijiPointer)var8_9).copy());
                                break;
                            }
                            if (var8_9 instanceof FijiWord) {
                                this.push(((FijiWord)var8_9).copy());
                                break;
                            }
                            this.push(var8_9);
                            break;
                        }
                        case -46: {
                            this.pushReturn(this.pop());
                            break;
                        }
                        case -45: {
                            this.push(this.popReturn());
                            break;
                        }
                        case -44: {
                            this.push(this.pickReturn(0));
                            break;
                        }
                        case -56: {
                            this.pop();
                            break;
                        }
                        case -51: {
                            this.push(this.program.objects[this.program.objectX++]);
                            break;
                        }
                        case 68: {
                            var5_6 = ((Number)this.pop()).intValue();
                            var8_9 = this.pop();
                            this.replace(var5_6, var8_9);
                            break;
                        }
                        case -50: {
                            this.bytes.addElement(new Byte(-51));
                            this.objects.addElement(this.pop());
                            break;
                        }
                        case -53: {
                            var5_6 = this.DS.size() - 1;
                            var8_9 = this.DS.elementAt(var5_6);
                            this.DS.setElementAt(this.DS.elementAt(var5_6 - 1), var5_6);
                            this.DS.setElementAt(var8_9, var5_6 - 1);
                            break;
                        }
                        case -52: {
                            var5_6 = this.DS.size() - 1;
                            var8_9 = this.DS.elementAt(var5_6 - 2);
                            this.DS.setElementAt(this.DS.elementAt(var5_6 - 1), var5_6 - 2);
                            this.DS.setElementAt(this.DS.elementAt(var5_6), var5_6 - 1);
                            this.DS.setElementAt(var8_9, var5_6);
                            break;
                        }
                        case -49: {
                            var7_8 = ((Number)this.pop()).intValue();
                            var8_9 = this.pick(var7_8);
                            var5_6 = var7_8;
                            while (true) {
                                if (var5_6 <= 0) {
                                    this.replace(0, var8_9);
                                    break block0;
                                }
                                this.replace(var5_6, this.pick(var5_6 - 1));
                                --var5_6;
                            }
                        }
                        case -100: {
                            var7_8 = ((Number)this.pop()).intValue();
                            var8_9 = this.pickControl(var7_8);
                            var5_6 = var7_8;
                            while (true) {
                                if (var5_6 <= 0) {
                                    this.replaceControl(0, var8_9);
                                    break block0;
                                }
                                this.replaceControl(var5_6, this.pickControl(var5_6 - 1));
                                --var5_6;
                            }
                        }
                        case -48: {
                            var5_6 = ((Number)this.pop()).intValue();
                            this.push(this.pick(var5_6));
                            break;
                        }
                        case -99: {
                            var5_6 = ((Number)this.pop()).intValue();
                            this.push(this.pickControl(var5_6));
                            break;
                        }
                        case 64: {
                            var5_6 = ((Number)this.pop()).intValue();
                            this.push(this.pickLocal(var5_6));
                            break;
                        }
                        case 67: {
                            var5_6 = ((Number)this.pop()).intValue();
                            this.replaceLocal(var5_6, this.pop());
                            break;
                        }
                        case 65: {
                            this.pushLocal(this.pop());
                            break;
                        }
                        case 66: {
                            this.push(this.popLocal());
                            break;
                        }
                        case -29: {
                            var10_11 = (FijiPointer)this.pop();
                            var8_9 = this.pop();
                            if (var10_11.serialNumber == this.newWord.PFA.serialNumber && this.creating) {
                                this.objects.setElementAt(var8_9, var10_11.objectX);
                                break;
                            }
                            var10_11.objects[var10_11.objectX] = var8_9;
                            break;
                        }
                        case -23: 
                        case -22: {
                            var5_6 = ((Number)this.pop()).intValue();
                            var10_11 = (FijiPointer)this.tos();
                            if (var15_16 == -22) {
                                var5_6 = -var5_6;
                            }
                            var10_11.byteX += var5_6;
                            break;
                        }
                        case -24: {
                            var10_11 = (FijiPointer)this.pop();
                            var19_21 = (Byte)this.pop();
                            if (var10_11.serialNumber == this.newWord.PFA.serialNumber && this.creating) {
                                this.bytes.setElementAt(var19_21, var10_11.byteX);
                                break;
                            }
                            var10_11.bytes[var10_11.byteX] = var19_21;
                            break;
                        }
                        case -47: {
                            this.push(this.DS.size());
                            break;
                        }
                        case -26: {
                            var10_11 = (FijiPointer)this.pop();
                            if (var10_11.serialNumber == this.newWord.PFA.serialNumber && this.creating) {
                                this.push(this.bytes.elementAt(var10_11.byteX));
                            } else {
                                this.push(var10_11.bytes[var10_11.byteX]);
                            }
                        }
                        case -31: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: {
                            var10_11 = (FijiPointer)this.pop();
                            if (var10_11.serialNumber == this.newWord.PFA.serialNumber && this.creating) {
                                this.push(this.objects.elementAt(var10_11.objectX));
                            } else {
                                this.push(var10_11.objects[var10_11.objectX]);
                            }
                            if (var15_16 == -31) continue block166;
                            var15_16 = (byte)(var15_16 + -8);
                        }
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: {
                            var8_9 = this.pop();
                            block155 : switch (var15_16) {
                                case 20: 
                                case 21: {
                                    var19_22 = var8_9.toString();
                                    System.out.print((String)var19_22);
                                    break;
                                }
                                default: {
                                    if (!(var8_9 instanceof Number)) ** GOTO lbl421
                                    var19_22 = null;
                                    var20_30 = null;
                                    if (var8_9 instanceof Long) {
                                        var19_22 = (Long)var8_9;
                                    } else {
                                        var20_30 = (Number)var8_9;
                                    }
                                    switch (var15_16) {
                                        case 22: 
                                        case 23: {
                                            if (var19_22 != null) {
                                                var21_32 = Long.toHexString(var19_22.longValue());
                                                System.out.print(var21_32);
                                                break block155;
                                            }
                                            var21_33 = Integer.toHexString(var20_30.intValue());
                                            System.out.print(var21_33);
                                            break block155;
                                        }
                                        case 24: 
                                        case 25: {
                                            if (var19_22 != null) {
                                                var21_34 = Long.toOctalString(var19_22.longValue());
                                                System.out.print(var21_34);
                                                break block155;
                                            }
                                            var21_35 = Integer.toOctalString(var20_30.intValue());
                                            System.out.print(var21_35);
                                            break block155;
                                        }
                                        case 26: 
                                        case 27: {
                                            if (var19_22 != null) {
                                                var21_36 = Long.toBinaryString(var19_22.longValue());
                                                System.out.print(var21_36);
                                                break block155;
                                            }
                                            var21_37 = Integer.toBinaryString(var20_30.intValue());
                                            System.out.print(var21_37);
                                            break block155;
                                        }
lbl421:
                                        // 1 sources

                                        var19_22 = var8_9.toString();
                                        System.out.print((String)var19_22);
                                        break block155;
                                    }
                                }
                            }
                            switch (var15_16) {
                                case 20: 
                                case 22: 
                                case 24: 
                                case 26: {
                                    System.out.print(" ");
                                    break block0;
                                }
                            }
                            if (var18_2) continue block167;
                            return;
                        }
                        case 36: {
                            var5_6 = ((Number)this.pop()).intValue();
                            var12_13 = this.pop().toString();
                            var19_23 = this.padString(var12_13, var5_6);
                            System.out.print(var19_23);
                            break;
                        }
                        case 40: {
                            var3_4 = (char)((Number)this.pop()).intValue();
                            System.out.print(var3_4);
                            break;
                        }
                        case 39: {
                            System.out.println("");
                            break;
                        }
                        case -112: 
                        case -110: {
                            var14_15 = var15_16 == -112 ? (FijiWord)this.program.objects[this.program.objectX++] : (FijiWord)this.pop();
                            var14_15.execute(this);
                            break;
                        }
                        case -114: {
                            var14_15 = (FijiWord)this.pop();
                            this.push(var14_15.PFA);
                            break;
                        }
                        case -113: {
                            var14_15 = (FijiWord)this.pop();
                            this.push(var14_15.CFA);
                            break;
                        }
                        case -21: {
                            var14_15 = (FijiWord)this.pop();
                            var14_15.PFA = var10_11 = (FijiPointer)this.pop();
                            break;
                        }
                        case -20: {
                            var14_15 = (FijiWord)this.pop();
                            var14_15.CFA = var10_11 = (FijiPointer)this.pop();
                            break;
                        }
                        case 53: {
                            var10_11 = (FijiPointer)this.pop();
                            this.push(var10_11.byteX);
                            break;
                        }
                        case 54: {
                            var10_11 = (FijiPointer)this.pop();
                            this.push(var10_11.objectX);
                            break;
                        }
                        case 57: {
                            var10_11 = (FijiPointer)this.pop();
                            this.push(var10_11.serialNumber);
                            break;
                        }
                        case 55: {
                            var5_6 = ((Number)this.pop()).intValue();
                            var10_11 = (FijiPointer)this.tos();
                            var10_11.byteX = var5_6;
                            break;
                        }
                        case 56: {
                            var5_6 = ((Number)this.pop()).intValue();
                            var10_11 = (FijiPointer)this.tos();
                            var10_11.objectX = var5_6;
                            break;
                        }
                        case -4: 
                        case -3: 
                        case 58: {
                            var12_13 = var15_16 == -3 ? (String)this.pop() : this.nextNonWhiteToken();
                            if (var12_13 == null) continue block166;
                            var14_15 = this.lookup(var12_13);
                            if (var15_16 == 58) {
                                this.handleLater((byte)-51, var14_15, null);
                                break;
                            }
                            this.push(var14_15);
                            break;
                        }
                        case -9: {
                            if (this.compiling) {
                                this.postponeNext = true;
                                break;
                            }
                            System.out.println("calling postpone while not compiling!  ignoring.");
                            break;
                        }
                        case -8: {
                            var14_15 = (FijiWord)this.program.objects[this.program.objectX++];
                            this.handleWord(var14_15);
                            break;
                        }
                        case -7: {
                            var2_3 = this.program.bytes[this.program.byteX++];
                            this.handleByteCode(var2_3);
                            break;
                        }
                        case -2: {
                            this.bytes.addElement(new Byte(this.program.bytes[this.program.byteX++]));
                            break;
                        }
                        case 17: {
                            this.objects.addElement(this.program.objects[this.program.objectX++]);
                            break;
                        }
                        case -12: {
                            this.compiling = false;
                            break;
                        }
                        case -11: {
                            this.compiling = true;
                            break;
                        }
                        case -10: {
                            this.push(new Integer(this.compiling != false ? 1 : 0));
                            break;
                        }
                        case 18: {
                            if (!this.compiling) {
                                System.out.println("calling recurse while not compiling!  ignoring.");
                                break;
                            }
                            this.handleLater((byte)-112, this.newWord, null);
                            break;
                        }
                        case -18: 
                        case -17: {
                            if (this.compiling) {
                                System.out.println("executing colon while already compiling!  ignoring.");
                                break;
                            }
                        }
                        case -15: 
                        case -14: {
                            if (!this.moreTokens()) {
                                System.out.println("executing \"create\" or \":\" as last word in stream!  ignoring.");
                                break;
                            }
                            this.finalizeEntry();
                            this.creating = true;
                            var19_24 = var15_16 == -15 || var15_16 == -18 ? this.nextNonWhiteToken() : (String)this.pop();
                            this.newWord = new FijiWord(var19_24);
                            this.newWord.PFA = new FijiPointer();
                            this.dictionary.add(this.newWord);
                            if (var15_16 == -18 || var15_16 == -17) {
                                this.compiling = true;
                                this.newWord.CFA = FijiInterpreter.doColon;
                                this.newWord.smudged = true;
                            }
                            this.bytes.removeAllElements();
                            this.objects.removeAllElements();
                            break;
                        }
                        case 19: {
                            if (!this.compiling) {
                                System.out.println("calling does> when not compiling!  ignoring.");
                                break;
                            }
                            this.doesProgram = var10_11 = FijiInterpreter.doDoes.copy();
                            this.handleLater((byte)-19, var10_11, null);
                            this.handleLater((byte)-111, null, null);
                            var10_11.byteX = this.bytes.size();
                            var10_11.objectX = this.objects.size();
                            break;
                        }
                        case -6: {
                            if (this.newWord == null) continue block166;
                            this.newWord.immediate = true;
                            break;
                        }
                        case -5: {
                            if (this.newWord == null) continue block166;
                            this.newWord.inline = true;
                            break;
                        }
                        case -32: {
                            this.objects.addElement(this.pop());
                            break;
                        }
                        case -27: {
                            this.bytes.addElement((Byte)this.pop());
                            break;
                        }
                        case -33: 
                        case -28: {
                            var7_8 = ((Number)this.pop()).intValue();
                            var8_9 = var15_16 == -33 ? new Integer(0) : new Byte(0);
                            var5_6 = 0;
                            while (var5_6 < var7_8) {
                                if (var15_16 == -33) {
                                    this.objects.addElement(var8_9);
                                } else {
                                    this.bytes.addElement(var8_9);
                                }
                                ++var5_6;
                            }
                            continue block166;
                        }
                        case -16: {
                            this.compiling = false;
                            this.newWord.smudged = false;
                        }
                        case -19: {
                            if (var15_16 == -19) {
                                this.newWord.CFA = (FijiPointer)this.program.objects[this.program.objectX++];
                            }
                        }
                        case -13: {
                            if (!this.creating) {
                                System.out.println("executing finalize (semicolon) without creating something first!  ignoring.");
                                break;
                            }
                            this.finalizeEntry();
                            break;
                        }
                        case -115: {
                            var8_9 = this.pop();
                            this.push(var8_9.getClass().getName());
                            break;
                        }
                        case -30: {
                            var8_9 = this.pop();
                            if (var8_9 instanceof String) {
                                this.push(((String)var8_9).length());
                                break;
                            }
                            var10_11 = (FijiPointer)var8_9;
                            if (var10_11.objects == null) {
                                this.push(-1);
                                break;
                            }
                            this.push(var10_11.objects.length);
                            break;
                        }
                        case -25: {
                            var10_11 = (FijiPointer)this.pop();
                            if (var10_11.bytes == null) {
                                this.push(-1);
                                break;
                            }
                            this.push(var10_11.bytes.length);
                            break;
                        }
                        case -41: 
                        case -40: {
                            v1 = var12_13 = var15_16 == -41 ? this.nextToken() : this.nextNonWhiteToken();
                            if (var12_13 == null) {
                                var12_13 = "";
                            }
                            this.push(var12_13);
                            break;
                        }
                        case -39: {
                            this.push(this.moreTokens() != false ? 1 : 0);
                            break;
                        }
                        case -38: {
                            var12_13 = (String)this.pop();
                            this.putBackToken(var12_13);
                            break;
                        }
                        case -126: {
                            this.replace(0, this.tos().toString());
                            break;
                        }
                        case -123: {
                            this.replace(0, new Double(((Number)this.tos()).doubleValue()));
                            break;
                        }
                        case -122: {
                            this.replace(0, new Float(((Number)this.tos()).floatValue()));
                            break;
                        }
                        case -121: {
                            this.replace(0, new Long(((Number)this.tos()).longValue()));
                            break;
                        }
                        case -120: {
                            this.replace(0, new Integer(((Number)this.tos()).intValue()));
                            break;
                        }
                        case -119: {
                            this.replace(0, new Short(((Number)this.tos()).shortValue()));
                            break;
                        }
                        case -117: {
                            this.replace(0, new Character((char)((Number)this.tos()).intValue()));
                            break;
                        }
                        case -118: {
                            this.replace(0, new Byte(((Number)this.tos()).byteValue()));
                            break;
                        }
                        case -116: {
                            var8_9 = this.tos();
                            if (var8_9 instanceof Boolean) continue block166;
                            var8_9 = var8_9 instanceof String != false ? new Boolean(var8_9.toString()) : new Boolean(((Number)var8_9).intValue() != 0);
                            this.replace(0, var8_9);
                            break;
                        }
                        case 46: {
                            var12_13 = (String)this.pop();
                            this.prefixVector.addElement(var12_13);
                            break;
                        }
                        case 47: {
                            var12_13 = (String)this.pop();
                            this.prefixVector.removeElement(var12_13);
                            break;
                        }
                        case -37: {
                            var13_14 = (String)this.pop();
                            var12_13 = (String)this.pop();
                            var5_6 = var12_13.toLowerCase().compareTo(var13_14.toLowerCase());
                            this.push(new Integer(var5_6));
                            break;
                        }
                        case -36: {
                            var13_14 = (String)this.pop();
                            var12_13 = (String)this.pop();
                            var5_6 = 0;
                            var19_25 = new StringTokenizer(var12_13, var13_14, true);
                            while (true) {
                                if (!var19_25.hasMoreTokens()) {
                                    this.push(new Integer(var5_6));
                                    break block0;
                                }
                                ++var5_6;
                                this.push(var19_25.nextToken());
                            }
                        }
                        case -35: {
                            var7_8 = ((Number)this.pop()).intValue();
                            var5_6 = ((Number)this.pop()).intValue();
                            var12_13 = (String)this.pop();
                            this.push(var12_13.substring(var5_6, var7_8));
                            break;
                        }
                        case -34: {
                            var12_13 = (String)this.pop();
                            if (var12_13.length() > 0) {
                                this.push(var12_13.substring(1));
                                this.push(new Character(var12_13.charAt(0)));
                                break;
                            }
                            this.push(var12_13);
                            this.push(new Character('\u0000'));
                            break;
                        }
                        case -111: {
                            if (this.program.localCount != 0) {
                                var7_8 = (Integer)this.popLocal();
                                var5_6 = 0;
                                while (var5_6 < var7_8) {
                                    this.popLocal();
                                    ++var5_6;
                                }
                            }
                            if (this.RS.size() == 0) {
                                return;
                            }
                            this.program = (FijiPointer)this.popReturn();
                            break;
                        }
                        case 37: {
                            this.noByeYet = false;
                        }
                        case -109: {
                            return;
                        }
                        case 44: {
                            var12_13 = (String)this.pop();
                            this.interpretFile(var12_13);
                            break;
                        }
                        case 43: {
                            var12_13 = (String)this.pop();
                            this.interpret(var12_13);
                            break;
                        }
                        case 38: {
                            this.push(new Long(System.currentTimeMillis()));
                            break;
                        }
                        case 49: {
                            var7_8 = ((Number)this.pop()).intValue();
                            var11_12 = (FijiPointer)this.pop();
                            var10_11 = (FijiPointer)this.pop();
                            var5_6 = 0;
                            while (var5_6 < var7_8) {
                                var11_12.objects[var11_12.objectX + var5_6] = var10_11.objects[var10_11.objectX + var5_6];
                                ++var5_6;
                            }
                            continue block166;
                        }
                        case 42: {
                            if (!this.moreTokens()) {
                                System.out.println("executing \"see\" as last word in stream!  ignoring.");
                                break;
                            }
                            var12_13 = this.nextNonWhiteToken();
                            var14_15 = this.lookup(var12_13);
                            var19_26 = "[| see \"" + var12_13 + "\" begin ] " + var14_15.toString();
                            System.out.print(var19_26);
                            if (var14_15 == null) {
                                System.out.println("does not exist! ]");
                                break;
                            }
                            var19_27 = var14_15.CFA == FijiWord.doVariable;
                            System.out.println("");
                            System.out.print(" | CFA: ");
                            if (var19_27) {
                                System.out.println("(variable)");
                            } else if (var14_15.CFA == FijiInterpreter.doColon) {
                                var20_30 = "(do-colon) " + var14_15.CFA.toString();
                                System.out.println((String)var20_30);
                            } else if (var14_15.CFA instanceof FijiDoDoes) {
                                System.out.println("(do-does)");
                                var20_30 = " |   locals: " + (var14_15.CFA.locals == null ? "none" : var14_15.CFA.locals.toString());
                                System.out.println((String)var20_30);
                                this.dumpWordProgram(var14_15.CFA, true);
                            } else if (var14_15.CFA == FijiInterpreter.doLocal) {
                                System.out.println("(do-local)");
                            } else if (var14_15.CFA != null) {
                                var20_30 = var14_15.CFA.toString();
                                System.out.println((String)var20_30);
                            } else {
                                System.out.println("null!");
                            }
                            var20_30 = " | PFA: " + var14_15.PFA.toString();
                            System.out.println((String)var20_30);
                            var20_30 = " |   locals: " + (var14_15.PFA.locals == null ? "none" : var14_15.PFA.locals.toString());
                            System.out.println((String)var20_30);
                            var20_30 = " |   byteX: " + var14_15.PFA.byteX;
                            System.out.println((String)var20_30);
                            var20_30 = " |   objectX: " + var14_15.PFA.objectX;
                            System.out.println((String)var20_30);
                            System.out.print(" |   Program: ");
                            if (var14_15.PFA.bytes == null) {
                                System.out.println(" null!  must not be finalized yet.");
                            } else {
                                var20_30 = String.valueOf(var14_15.PFA.bytes.length) + " byte codes, " + var14_15.PFA.objects.length + " objects";
                                System.out.println((String)var20_30);
                                this.dumpWordProgram(var14_15.PFA, var19_27 == false);
                            }
                            var20_30 = "[| see \"" + var12_13 + "\" end ]";
                            System.out.println((String)var20_30);
                            break;
                        }
                        case 50: {
                            this.push(this);
                            break;
                        }
                        case 60: {
                            this.push(new FijiDictionary());
                            break;
                        }
                        case 61: {
                            var10_11 = (FijiPointer)this.pop();
                            this.push(var10_11.locals);
                            break;
                        }
                        case 62: {
                            var10_11 = (FijiPointer)this.pop();
                            var8_9 = this.pop();
                            var10_11.locals = (FijiDictionary)var8_9;
                            break;
                        }
                        case 63: {
                            var5_6 = (Integer)this.pop();
                            var8_9 = this.pop();
                            if (var5_6 == 0) continue block166;
                            var10_11 = this.doesProgram != null ? this.doesProgram : this.newWord.PFA;
                            if (var10_11.locals == null) {
                                var10_11.locals = new FijiDictionary();
                                var10_11.localCount = 1;
                            } else {
                                ++var10_11.localCount;
                            }
                            var12_13 = (String)var8_9;
                            var14_15 = new FijiWord(var12_13);
                            var14_15.CFA = FijiInterpreter.doLocal;
                            var14_15.PFA = new FijiPointer();
                            var14_15.PFA.bytes = new byte[1];
                            var14_15.PFA.bytes[0] = -111;
                            var14_15.PFA.objects = new Object[1];
                            var14_15.PFA.objects[0] = new Integer(var10_11.localCount);
                            var10_11.locals.add(var14_15);
                            break;
                        }
                        case 59: {
                            this.push(this.newWord);
                            break;
                        }
                        case 48: {
                            var19_28 = (String)this.pop();
                            var20_30 = this.ensureFinal((FijiPointer)this.pop());
                            var22_39 = (String)this.pop();
                            var23_40 = this.ensureFinal((FijiPointer)this.pop());
                            var24_41 = (String)this.pop();
                            if (var20_30.objects.length == 0) {
                                var21_38 = null;
                            } else {
                                var25_43 = var20_30.objects.length;
                                var21_38 = new String[var25_43];
                                System.arraycopy(var20_30.objects, 0, var21_38, 0, var25_43);
                            }
                            var25_42 = var23_40.objects;
                            if (var19_28 == "java.lang.Void") {
                                var19_28 = null;
                            }
                            if ((var8_9 = new FijiReflect(var24_41, var25_42, (String)var22_39, var21_38, var19_28)) != null) {
                                this.push(var8_9);
                                this.push(1);
                                break;
                            }
                            this.push(FijiInterpreter.doVariable);
                            this.push(0);
                            break;
                        }
                        default: {
                            var19_29 = "unhandled bytecode: " + this.program.bytes[this.program.byteX - 1];
                            System.out.println(var19_29);
                            break;
                        }
lbl860:
                        // 1 sources

                        while ((var12_13 = this.nextToken()).indexOf(13) == -1) {
                            cfr_temp_0 = 41;
                            if (var12_13.indexOf(10) != -1) continue block166;
                        }
                        continue block166;
                        case 41: {
                            if (this.moreTokens()) ** GOTO lbl860
                            break;
                        }
                        while (true) {
                            cfr_temp_0 = 45;
                            var12_13 = this.nextToken();
                            var5_6 = var12_13.indexOf(41);
                            if (var5_6 == -1) continue block168;
                            if (var12_13.length() <= var5_6 + 1) continue block166;
                            this.putBackToken(var12_13.substring(var5_6 + 1));
                            break block0;
                            break;
                        }
                        case 45: {
                            if (this.moreTokens()) ** continue;
                            break;
                        }
                    }
                    continue block166;
                } while (true);
                break;
            }
        }
    }

    String padString(String string, int n) {
        int n2 = n - string.length();
        if (n2 > padStringLength) {
            string = this.padString(string, n2 - padStringLength);
        }
        if (n2 > 0) {
            string = String.valueOf(padString.substring(0, n - string.length())) + string;
        }
        return string;
    }

    void dumpWordProgram(FijiPointer fijiPointer, boolean bl) {
        int n;
        int n2 = n = fijiPointer.objectX;
        boolean bl2 = false;
        int n3 = fijiPointer.byteX;
        while (n3 < fijiPointer.bytes.length) {
            String string = " |    " + (bl2 ? "   " : "") + this.padString("b" + Integer.toString(n3), 4) + ": " + this.padString(Byte.toString(fijiPointer.bytes[n3]), 4) + " = " + byteToString[fijiPointer.bytes[n3] + 128];
            System.out.println(string);
            if (bl2) {
                bl2 = false;
            } else {
                n2 += byteArgumentCount[fijiPointer.bytes[n3] + 128];
            }
            if (bl) {
                while (n < n2) {
                    string = " |         o" + n + ": " + (fijiPointer.objects[n] == null ? "null!" : String.valueOf(fijiPointer.objects[n].getClass().getName()) + " = \"" + fijiPointer.objects[n].toString() + "\"");
                    System.out.println(string);
                    ++n;
                }
            }
            bl2 = bl && (fijiPointer.bytes[n3] == -2 || fijiPointer.bytes[n3] == -7);
            ++n3;
        }
        if (n < fijiPointer.objects.length) {
            if (bl) {
                System.out.println(" |   Unused objects (!):");
            } else {
                System.out.println(" |   Objects:");
            }
            int n4 = n;
            while (n4 < fijiPointer.objects.length) {
                String string = " |      o" + n4 + ": " + fijiPointer.objects[n4].getClass().getName() + " = \"" + fijiPointer.objects[n4].toString() + "\"";
                System.out.println(string);
                ++n4;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    Object getObject(String var1_1) {
        var2_2 = 10;
        if (var1_1.charAt(0) == '-') {
            var1_1 = var1_1.substring(1);
            var3_3 = true;
        } else {
            var3_3 = false;
        }
        if (var1_1.charAt(0) == '0') {
            switch (var1_1.charAt(1)) {
                case 'x': {
                    var2_2 = 16;
                    var1_1 = var1_1.substring(2);
                    break;
                }
                case 'b': {
                    var2_2 = 2;
                    var1_1 = var1_1.substring(2);
                    break;
                }
                case 'o': {
                    var2_2 = 8;
                    var1_1 = var1_1.substring(2);
                }
            }
        }
        if (var3_3) {
            var1_1 = String.valueOf('-') + var1_1;
        }
        var4_4 = true;
        var5_5 = var1_1.charAt(var1_1.length() - 1);
        switch (var5_5) {
            default: {
                var4_4 = false;
                var5_5 = 46;
            }
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 76: 
            case 83: 
        }
        if (var4_4) {
            var1_1 = var1_1.substring(0, var1_1.length() - 1);
        }
        switch (var5_5) {
            case 66: {
                try {
                    return Byte.valueOf(var1_1, var2_2);
                }
                catch (NumberFormatException v0) {}
            }
            case 67: {
                try {
                    return new Character((char)Integer.parseInt(var1_1, var2_2));
                }
                catch (NumberFormatException v1) {}
            }
            case 83: {
                try {
                    return Short.valueOf(var1_1, var2_2);
                }
                catch (NumberFormatException v2) {}
            }
            case 46: 
            case 73: {
                try {
                    return Integer.valueOf(var1_1, var2_2);
                }
                catch (NumberFormatException v3) {
                    if (var5_5 != 46) ** GOTO lbl53
                    try {
                        return new Double(var1_1);
                    }
                    catch (NumberFormatException v4) {
                        return null;
                    }
                }
            }
lbl53:
            // 2 sources

            case 76: {
                try {
                    return Long.valueOf(var1_1, var2_2);
                }
                catch (NumberFormatException v5) {}
            }
            case 70: {
                try {
                    return new Float(var1_1);
                }
                catch (NumberFormatException v6) {}
            }
            case 68: {
                try {
                    return new Double(var1_1);
                }
                catch (NumberFormatException v7) {}
            }
        }
        return null;
    }

    boolean moreTokens() {
        return this.t.hasMoreTokens() || this.pushedString != null;
    }

    String getPrefix(String string) {
        if (this.prefixVector == null) {
            this.prefixVector = new Vector();
            this.prefixVector.addElement("\"");
            this.prefixVector.addElement(".\"");
            this.prefixVector.addElement("\\");
            this.prefixVector.addElement("//");
            this.prefixVector.addElement("(");
        }
        int n = 0;
        while (n < this.prefixVector.size()) {
            String string2 = (String)this.prefixVector.elementAt(n);
            if (string.length() > string2.length() && string.substring(0, string2.length()).compareTo(string2) == 0) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    void putBackToken(String string) {
        this.pushedString = string;
    }

    String nextToken() {
        String string;
        if (this.pushedString != null) {
            string = this.pushedString;
            this.pushedString = null;
        } else {
            if (!this.t.hasMoreTokens()) {
                return null;
            }
            string = this.t.nextToken();
        }
        return string;
    }

    String splitOnPrefix(String string) {
        String string2 = this.getPrefix(string);
        if (string2 != null) {
            this.pushedString = string.substring(string2.length());
            return string2;
        }
        return null;
    }

    String nextNonWhiteToken() {
        while (this.moreTokens()) {
            String string = this.nextToken();
            if (string.trim().length() == 0) continue;
            return string;
        }
        return null;
    }

    void inlineWord(FijiPointer fijiPointer) {
        int n = fijiPointer.byteX;
        int n2 = fijiPointer.objectX;
        int n3 = this.bytes.size();
        int n4 = this.objects.size();
        boolean bl = true;
        n = 0;
        while (bl && n < fijiPointer.bytes.length) {
            switch (fijiPointer.bytes[n]) {
                case -111: {
                    bl = false;
                    break;
                }
                case -108: 
                case -107: 
                case -106: 
                case -105: {
                    this.objects.addElement(new Integer(n3 + (Integer)fijiPointer.objects[n2++]));
                    this.objects.addElement(new Integer(n4 + (Integer)fijiPointer.objects[n2++]));
                    break;
                }
                default: {
                    int n5 = byteArgumentCount[fijiPointer.bytes[n] + 128];
                    while (n5 > 0) {
                        this.objects.addElement(fijiPointer.objects[n2++]);
                        --n5;
                    }
                    break block0;
                }
            }
            if (bl) {
                this.bytes.addElement(new Byte(fijiPointer.bytes[n]));
            }
            ++n;
        }
        while (n2 < fijiPointer.objects.length) {
            this.objects.addElement(fijiPointer.objects[n2++]);
            ++n2;
        }
    }

    void handleNow(byte by, Object object) {
        if (this.postponeNext) {
            this.postponeNext = false;
            this.handleLater(by, object, null);
            return;
        }
        this.handleProgram.bytes[0] = by;
        this.handleProgram.byteX = 0;
        if (object != null) {
            this.handleProgram.objects[0] = object;
            this.handleProgram.objectX = 0;
        }
        this.interpret(this.handleProgram);
        this.handleProgram.byteX = 1;
    }

    void handleLater(byte by, Object object, Object object2) {
        if (this.postponeNext) {
            this.postponeNext = false;
            if (by == -112) {
                this.handleLater((byte)-8, object, null);
                return;
            }
            this.handleLater((byte)-7, null, null);
            this.handleLater(by, null, null);
            return;
        }
        if (by == -112 && object != null) {
            FijiWord fijiWord = (FijiWord)object;
            if (fijiWord.inline && fijiWord.CFA instanceof FijiDoColon) {
                this.inlineWord(fijiWord.PFA);
                return;
            }
        }
        this.bytes.addElement(new Byte(by));
        if (object != null) {
            this.objects.addElement(object);
            if (object2 != null) {
                this.objects.addElement(object2);
            }
        }
    }

    void handleObject(Object object) {
        if (!this.compiling) {
            this.handleNow((byte)-51, object);
            return;
        }
        this.handleLater((byte)-51, object, null);
    }

    void handleWord(FijiWord fijiWord) {
        if (!this.compiling || fijiWord.immediate) {
            this.handleNow((byte)-112, fijiWord);
            return;
        }
        this.handleLater((byte)-112, fijiWord, null);
    }

    void handleByteCode(byte by) {
        block5: {
            block4: {
                if (!this.compiling) break block4;
                if (byteImmediate == null) {
                    FijiInterpreter.getByteCode(".");
                }
                if (!byteImmediate[by + 128]) break block5;
            }
            this.handleNow(by, null);
            return;
        }
        this.handleLater(by, null, null);
    }

    boolean interpretToken(String string) {
        FijiWord fijiWord = this.lookup(string);
        if (fijiWord != null) {
            this.handleWord(fijiWord);
            return true;
        }
        byte by = FijiInterpreter.getByteCode(string);
        if (by != -127) {
            this.handleByteCode(by);
            return true;
        }
        return false;
    }

    public void interpret(String string) {
        String string2;
        StringTokenizer stringTokenizer = this.t;
        this.t = new StringTokenizer(string, " \t\r\n", true);
        while ((string2 = this.nextNonWhiteToken()) != null) {
            String string3;
            if (this.interpretToken(string2) || (string3 = this.splitOnPrefix(string2)) != null && this.interpretToken(string3)) continue;
            Object object = this.getObject(string2);
            if (object != null) {
                this.handleObject(object);
                continue;
            }
            String string4 = "got unknown word: \"" + string2 + "\"";
            System.out.println(string4);
        }
        this.t = stringTokenizer;
    }

    public void interpret(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        if (bufferedReader == null) {
            String string = "error: could not create buffered reader from \"" + reader.toString() + "\"";
            System.out.println(string);
            return;
        }
        String string = "";
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                string = String.valueOf(string) + "\n" + string2;
            }
        }
        catch (IOException iOException) {}
        this.interpret(string);
        bufferedReader = null;
    }

    public void interpretFile(String string) {
        FileReader fileReader;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = "error: could not open " + string + "\"";
            System.out.println(string2);
            return;
        }
        this.interpret(fileReader);
        fileReader = null;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Fiji: Forth Interpreter In Java  by Larry Hastings");
            System.out.println("");
            System.out.println("usage: fiji [ forthscript [ forthscript2 ... ] ]");
            System.out.println("runs all scripts on the command line, then drops into interactive mode.");
            System.out.println("in interactive mode, the prompt is \"ok\".");
            System.out.println("to get out of interactive mode, type");
            System.out.println("\tbye");
            System.out.println("and press Enter.");
            System.out.println("");
        }
        FijiInterpreter fijiInterpreter = new FijiInterpreter();
        FijiWord fijiWord = new FijiWord("javaaddfour");
        fijiWord.CFA = new FijiPlusFour();
        fijiInterpreter.dictionary.add(fijiWord);
        Object[] objectArray = new Object[]{new Integer(420)};
        String[] stringArray2 = new String[]{"java.lang.Integer"};
        FijiReflect fijiReflect = new FijiReflect("FijiPlusN", objectArray, "plus", stringArray2, "java.lang.Integer");
        FijiWord fijiWord2 = new FijiWord("javaaddfourtwenty");
        fijiWord2.CFA = fijiReflect;
        fijiInterpreter.dictionary.add(fijiWord2);
        Object[] objectArray2 = new Object[]{new Integer(17)};
        String[] stringArray3 = new String[]{"java.lang.Integer", "java.lang.Integer", "java.lang.String"};
        fijiReflect = new FijiReflect("FijiPlusN", objectArray2, "twoTimesAndPrint", stringArray3, "java.lang.Integer");
        FijiWord fijiWord3 = new FijiWord("javamultiplyplus17andprint");
        fijiWord3.CFA = fijiReflect;
        fijiInterpreter.dictionary.add(fijiWord3);
        int n = 0;
        while (n < stringArray.length) {
            fijiInterpreter.interpretFile(stringArray[n]);
            ++n;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (!fijiInterpreter.bye()) {
                System.out.println("ok");
                String string = bufferedReader.readLine();
                fijiInterpreter.interpret(string);
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static {
        doVariable = new FijiPointer();
        doColon = new FijiDoColon();
        doDoes = new FijiDoDoes();
        bytehash = null;
        byteToString = null;
        byteImmediate = null;
        byteArgumentCount = null;
        padString = "                                        ";
        padStringLength = padString.length();
    }
}

