/*
** [BEGIN NOTICE]
**
** Copyright (C) 2003 Larry Hastings
**
** This software is provided 'as-is', without any express or implied warranty.
** In no event will the authors be held liable for any damages arising from
** the use of this software.
**
** Permission is granted to anyone to use this software for any purpose,
** including commercial applications, and to alter it and redistribute
** it freely, subject to the following restrictions:
**
** 1. The origin of this software must not be misrepresented; you must not
**    claim that you wrote the original software. If you use this software
**    in a product, an acknowledgment in the product documentation would be
**    appreciated but is not required.
** 2. Altered source versions must be plainly marked as such, and must not be
**    misrepresented as being the original software.
** 3. This notice may not be removed or altered from any source distribution.
**
** The dx8Diagnostics / dx8Dynamic homepage is here:
**		http://www.midwinter.com/~lch/programming/dx8diagnostics/
**
** [END NOTICE]
*/

#include <stdio.h>

#include "dx8Diagnostics.h"



int main(int, char *[])
	{
	if (dx8DiagnosticsStartup() == S_OK)
		{
		LARGE_INTEGER startTime, endTime, performanceFrequency;
		QueryPerformanceFrequency(&performanceFrequency);

		dx8Diagnostics *diagnostics;
		dx8Diagnostics *diagnostics2;
		dx8DiagnosticsCreate(&diagnostics, "directx 8");
		dx8DiagnosticsCreate(&diagnostics2, "directx 8");

		QueryPerformanceCounter(&startTime);
		char *nonce = dx8DiagnosticsGetNonce(diagnostics);
		QueryPerformanceCounter(&endTime);
		printf("Nonce:\n%s\n\nFirst nonce took %f seconds to calculate.\nThat includes a one-time DirectX slowdown.\n\n", nonce, ((double)(endTime.QuadPart - startTime.QuadPart)) / performanceFrequency.QuadPart);

		// Now generate the nonce again, using a *different* handle.
		// The handle caches the nonce, and we want to force it to generate
		// it again from scratch.
		QueryPerformanceCounter(&startTime);
		dx8DiagnosticsGetNonce(diagnostics2);
		QueryPerformanceCounter(&endTime);
		printf("Second nonce took %f seconds to calculate.\nThis represents how long calculating the nonce would actually add to your game.\n\n", ((double)(endTime.QuadPart - startTime.QuadPart)) / performanceFrequency.QuadPart);
		

		QueryPerformanceCounter(&startTime);
		dx8DiagnosticsWrite(diagnostics);
		QueryPerformanceCounter(&endTime);
		printf("Diagnostics took %f seconds to calculate.\n", ((double)(endTime.QuadPart - startTime.QuadPart)) / performanceFrequency.QuadPart);

		dx8DiagnosticsDestroy(&diagnostics);
		dx8DiagnosticsDestroy(&diagnostics2);
		dx8DiagnosticsShutdown();
		}
	return 0;
	}
