/*
  quote.c
  by Heiji Horde (horde@reed.edu)
  Please send additions, deletions, corrections, and suggestions to me.

  This program is intended to be distributed free to any and all Babylon 5
  fans for their *personal use* only.

  If you like this program all I ask is that you send a letter to your local
  station stating your support for Babylon 5.
*/

#include	<stdio.h>
#include	<strings.h>

#define	pathconf	"/u/a/horde/prj/quote/list.cnf"
#define	MAXLINE		79

FILE *conffile;
FILE *trekfile;
char quotefile[MAXLINE];
char pathfile[MAXLINE];

static int rfile, rquote;

main(argc, argv)
    int argc;
    char **argv;
{
    if (argc == 1)
      {
	strcpy(pathfile,pathconf);
	srandom(getpid()%4993);
	readconfig();
      }
    else
      if (argc == 2)
        {
	  strcpy(pathfile,argv[1]);
	  srandom(getpid()%4993);
	  readconfig();
        }
      else
        {
	  printf("Usage: %s [configutation file]	gives you a random quote\n", argv[0]);
	  exit(1);
        }
}

readconfig()
{
  char *cfile;	
  char line[MAXLINE];
  int found=0;
  int linelen, numfile;	

  if ((conffile=fopen(pathfile,"r")) == NULL)
    printf("Couldn't find configuration file: %s\n", pathfile);
  else {
    cfile=fgets(line, MAXLINE, conffile);
    numfile=atoi(cfile);
    rfile = (random() % numfile)+1;
    for(found=1;found<=rfile;found++)
      if (fgets(line, MAXLINE, conffile) != NULL)
	;
      else
	printf("End of file error: %s\n", pathfile);
      linelen=strlen(line);
      strncpy(quotefile,line,linelen-1);
      fclose(conffile);
      getquote();
  }
}

getquote()
{
  int found=0, quote=0;
  int numquotes;
  char *cquote;
  char line[MAXLINE];
        
  if ((trekfile=fopen(quotefile,"r")) == NULL)
    printf("Couldn't find quotes file: %s\n", quotefile);
  else {
    cquote=fgets(line, MAXLINE, trekfile);
    numquotes=atoi(cquote);
    rquote = (random() % numquotes)+1;
    while ((fgets(line, MAXLINE, trekfile) != NULL) && (found <= rquote)) {
      if (strncmp(line, "%%", 2) == 0)
	found++;
      if (found==rquote)
	quote++;
      else
	quote=0;
      if (quote > 1)
	printf("%s", line);
    }
    fclose(trekfile);
  }
}
