/*
 * Guarded memory allocation, string handling functions.
 */
#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "gfuncs.h"

static void *
guard(void *result)
{
	if (result == NULL)
	{
		fprintf(stderr, "Out of memory!  Aborting.\n");
		abort();
	}

	return result;
}


void *
gmalloc(int size)
{
	return guard(malloc(size));
}

void *
grealloc(void *orig, int size)
{
	if (orig == NULL)
		return gmalloc(size);
	else
		return guard(realloc(orig, size));
}

char *
gstrdup(char *str)
{
	if (str == NULL)
		return NULL;

	return (char *) guard(strdup(str));
}

void *
gcalloc(int size)
{
	return guard(calloc(1, size));
}

int
gstrlen(char *str)
{
	if (str == NULL)
		return 0;
	return strlen(str);
}

void
gfree(void *ptr)
{
	if (ptr != NULL)
		free(ptr);
}
