//----------------------------------------------------------------------------------------
// File:                CallerIDSentryUDP.h
//
// Description: Contains definition of the network protocol for CallerIDSentry
//
//                              Copyright (c) 2001 Jeff Kohn. All Rights Reserved.
//----------------------------------------------------------------------------------------

#ifndef CALLERIDSENTRYUDP_H__
#define CALLERIDSENTRYUDP_H__


// Possible values for PacketType
//
#define CID_TYPE_SUBSCRIBE              1       // Param1 contains client port for callback; Param2 is client computer name/address
#define CID_TYPE_UNSUBSCRIBE    2       // Param2 is client computer name/address
#define CID_TYPE_INCOMING_CALL  3       // Param2 is caller's name, Param3 is caller's phone #
#define CID_TYPE_ERROR_CALL             4       // Equivalent of ICallerIDNotify.OnError() - Param2 is error message
#define CID_TYPE_TEST                   5       // When the server recieves on of these, it will bounce the packet
                                                                        // back to the client. Param2 is client's name/address, Param1 is port# for callback

// struct CallerIDDatagram
//
#pragma pack(1)
struct CallerIDDatagram
{
        unsigned int PacketType;        // See above for #defines
        unsigned int Param1;
        char             Param2[64];
        char             Param3[64];
};

#endif  // CALLERIDSENTRYUDP_H__
