#ifndef __prebuf_h__ /* { */
#define __prebuf_h__ 1

#include <stdio.h>

/*
 * Starts prebuffering a file.
 *
 * Input:
 *	File handle to start prebuffering.
 *	Maximum number of bytes to prebuffer.
 *	Number of bytes per read from the file.
 * Returns:
 *	0 on success, -1 on failure.
 */
extern int prebufstart(int fd, int max_bytes, int chunk_size);

/*
 * Stops prebuffering a file.
 *
 * Input:
 *	Handle of prebuffered file.
 */
extern void prebufstop(int fd);

/*
 * Reads from a prebuffered file.
 *
 * Input:
 *	Handle of prebuffered file.
 *	Buffer to fill.
 *	Size of buffer.
 * Returns:
 *	Number of bytes read, or -1 on failure.
 */
extern int prebufread(int fd, char *buf, int len);


#endif /* __prebuf_h__ } */
