#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

static void
add_string_to_list(char ***list, int *count, char *string)
{
	char **newlist;

	if (*count == 0 || *list == NULL)
		newlist = malloc(sizeof(char *));
	else
		newlist = realloc(*list, sizeof(char *) * (*count + 1));
	if (newlist == NULL)
	{
		perror("malloc");
		exit(1);
	}

	*list = newlist;
	newlist[*count] = strdup(string);
	if (newlist[*count] == NULL)
	{
		perror("strdup");
		exit(1);
	}

	++*count;
}

// Picks a song and attempts to not repeat songs very often.
int
pick_song(int nsongs, int *history, int history_size)
{
	int	tries_left = nsongs;
	int	i;
	int	song;

	// Trivial case: Only one song!
	if (nsongs == 1)
		return 0;

	while (tries_left--)
	{
		song = random() % nsongs;
		for (i = 0; i < history_size; i++)
			if (song == history[i])
				break;
		if (i == history_size)
			break;
	}

	memmove(history + 1, history, sizeof(*history) * (history_size - 1));
	history[0] = song;

	return song;
}


main(int argc, char **argv)
{
	FILE	*fp;
	char	**paths = NULL;
	char	buf[1500];
	char	*c;
	int	nsongs = 0;
	int	songnum;
	int	child;
	int	*history;
	int	history_size;

	srandom(getpid());

	if (argc != 2)
	{
		fprintf(stderr, "Usage: %s playlist.m3u\n", argv[0]);
		exit(1);
	}

	fp = fopen(argv[1], "r");
	if (fp == NULL)
	{
		perror(argv[1]);
		exit(1);
	}

	while (fgets(buf, sizeof(buf), fp) != NULL)
	{
		if (buf[0] == '#' || buf[0] == ';')
			continue;

		for (c = buf; *c; c++)
		{
			if (*c == '\\')
				*c = '/';
			if (*c == '\r' || *c == '\n')
			{
				*c = '\0';
				break;
			}
		}

		if (buf[0] == '\0')
			continue;

		add_string_to_list(&paths, &nsongs, buf);
	}

	printf("Playlist has %d songs\n", nsongs);
	history_size = nsongs / 2;
	if (history_size > 0)
		history = malloc(history_size * sizeof(int));

	for (songnum = 0; songnum < history_size; songnum++)
		history[songnum] = -1;

	while (1)
	{
		songnum = pick_song(nsongs, history, history_size);
		printf("Playing %s\n", paths[songnum]);
		fflush(stdout);

		child = fork();
		if (child == 0)
		{
			execlp("madplay", "madplay", paths[songnum], NULL);
			perror("madplay");
			exit(1);
		}
		if (child > 0)
			wait(NULL);
		if (child < 0)
		{
			perror("fork");
			exit(1);
		}
	}

	fclose(fp);
}
