#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#include <errno.h>

#ifndef MIN
#define MIN(a,b) (((a) < (b)) ? (a) : (b))
#endif

extern int errno;

/*
** clientsock()
**
** Returns a connected client socket.
**
** Input: host name and port number to connect to
** Output: file descriptor of CONNECTED socket, or a negative error (-9999
**         if the hostname was bad).
*/
int clientsock(host, port)
char *host;
int port;
{
	int	sock;
	struct	sockaddr_in server;
	struct	hostent *hp, *gethostbyname();

	bzero(&server, sizeof(server));
	server.sin_family = AF_INET;
	server.sin_port = htons(port);

	if (isdigit(host[0]))
		server.sin_addr.s_addr = inet_addr(host);
	else
	{
		hp = gethostbyname(host);
		if (hp == NULL)
			return -9999;
		bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
	}

	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock < 0)
		return -errno;

	if (connect(sock, (struct sockaddr *)&server, sizeof(server)) < 0)
	{
		close(sock);
		return -errno;
	}

	return sock;
}

/*
** getline()
**
** Fetches a \r\n-terminated line of text from a socket one byte at a time.
** Returns line length.
*/
int getline(int sock, char *buf)
{
	char c;
	int bytes;
	int len = 0;

	*buf = '\0';
	while ((bytes = read(sock, &c, 1)) == 1)
	{
		if (c == '\r')
			continue;
		if (c == '\n')
		{
			buf[len] = '\0';
			return len;
		}
		buf[len++] = c;
	}

	return -1;
}


/*
** http_start()
**
** Returns a connected socket at the start of the data from an HTTP GET.
*/
int http_sock(char *host, int port, char *file, int *length)
{
	int	sock;
	int	len;
	int	code;
	char	scratch[500];

	*length = -1;

	sock = clientsock(host, port);
	if (sock < 0)
		return sock;
	
	sprintf(scratch, "GET %s HTTP/1.0\r\nHost: %s\r\n\r\n", file, host);
	len = strlen(scratch);
	if (write(sock, scratch, len) < len)
	{
		close(sock);
		return -1;
	}

	/*
	 * Get the result code.
	 */
	if (getline(sock, scratch) < 0)
	{
		close(sock);
		return -1;
	}

	if (sscanf(scratch, "HTTP/1.1 %d ", &code) < 1)
	{
		close(sock);
		return -1;
	}

	if (code != 200)
	{
		close(sock);
		return -code;
	}

	/*
	 * Get response headers, looking for either content length or a
	 * blank line.
	 */
	while ((len = getline(sock, scratch)) > 0)
	{
		if (! strncmp(scratch, "Content-Length:", 15))
			sscanf(scratch + 16, "%d", length);
	}

	if (len < 0)
	{
		close(sock);
		return -1;
	}

	return sock;
}

main(int argc, char **argv)
{
	int	len, sock;
	char	buf[8192];
	int	bytesread;

	if (argc != 4)
	{
		fprintf(stderr, "Usage: %s host port file\n", argv[0]);
		exit(1);
	}

	sock = http_sock(argv[1], atoi(argv[2]), argv[3], &len);
	if (sock < 0)
	{
		fprintf(stderr, "Got error %d\n", sock);
		exit(1);
	}

	if (len == -1)
		len = 0x7fffffff;

	while (len > 0)
	{
		bytesread = read(sock, buf, MIN(len, sizeof(buf)));
		if (bytesread <= 0)
			break;

		len -= bytesread;

		if (write(1, buf, bytesread) < bytesread)
			break;
	}

	close(sock);
}
